/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpExecuteIntercepter;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.util.ArrayMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpTransport {
    static final Logger LOGGER = Logger.getLogger(HttpTransport.class.getName());
    @Deprecated
    public HttpHeaders defaultHeaders = new HttpHeaders();
    @Deprecated
    final ArrayMap<String, HttpParser> contentTypeToParserMap = ArrayMap.create();
    @Deprecated
    public List<HttpExecuteIntercepter> intercepters = new ArrayList<HttpExecuteIntercepter>(1);

    public final HttpRequestFactory createRequestFactory() {
        return this.createRequestFactory(null);
    }

    public final HttpRequestFactory createRequestFactory(HttpRequestInitializer initializer) {
        return new HttpRequestFactory(this, initializer);
    }

    @Deprecated
    public final void addParser(HttpParser parser) {
        String contentType = this.getNormalizedContentType(parser.getContentType());
        this.contentTypeToParserMap.put(contentType, parser);
    }

    @Deprecated
    public final HttpParser getParser(String contentType) {
        if (contentType == null) {
            return null;
        }
        contentType = this.getNormalizedContentType(contentType);
        return this.contentTypeToParserMap.get(contentType);
    }

    @Deprecated
    private String getNormalizedContentType(String contentType) {
        int semicolon = contentType.indexOf(59);
        return semicolon == -1 ? contentType : contentType.substring(0, semicolon);
    }

    @Deprecated
    public final HttpRequest buildRequest() {
        return new HttpRequest(this, null);
    }

    @Deprecated
    public final HttpRequest buildDeleteRequest() {
        return new HttpRequest(this, HttpMethod.DELETE);
    }

    @Deprecated
    public final HttpRequest buildGetRequest() {
        return new HttpRequest(this, HttpMethod.GET);
    }

    @Deprecated
    public final HttpRequest buildPostRequest() {
        return new HttpRequest(this, HttpMethod.POST);
    }

    @Deprecated
    public final HttpRequest buildPutRequest() {
        return new HttpRequest(this, HttpMethod.PUT);
    }

    @Deprecated
    public final HttpRequest buildPatchRequest() {
        return new HttpRequest(this, HttpMethod.PATCH);
    }

    @Deprecated
    public final HttpRequest buildHeadRequest() {
        return new HttpRequest(this, HttpMethod.HEAD);
    }

    @Deprecated
    public final void removeIntercepters(Class<?> intercepterClass) {
        Iterator<HttpExecuteIntercepter> iterable = this.intercepters.iterator();
        while (iterable.hasNext()) {
            HttpExecuteIntercepter intercepter = iterable.next();
            if (!intercepterClass.isAssignableFrom(intercepter.getClass())) continue;
            iterable.remove();
        }
    }

    public boolean supportsHead() {
        return false;
    }

    public boolean supportsPatch() {
        return false;
    }

    protected abstract LowLevelHttpRequest buildDeleteRequest(String var1) throws IOException;

    protected abstract LowLevelHttpRequest buildGetRequest(String var1) throws IOException;

    protected LowLevelHttpRequest buildHeadRequest(String url) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected LowLevelHttpRequest buildPatchRequest(String url) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected abstract LowLevelHttpRequest buildPostRequest(String var1) throws IOException;

    protected abstract LowLevelHttpRequest buildPutRequest(String var1) throws IOException;

    public void shutdown() throws IOException {
    }
}

