/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.javanet.NetHttpResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

final class NetHttpRequest
extends LowLevelHttpRequest {
    private final HttpURLConnection connection;
    private HttpContent content;

    NetHttpRequest(String requestMethod, String url) throws IOException {
        HttpURLConnection connection = this.connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod(requestMethod);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
    }

    public void addHeader(String name, String value) {
        this.connection.addRequestProperty(name, value);
    }

    public void setTimeout(int connectTimeout, int readTimeout) {
        this.connection.setReadTimeout(readTimeout);
        this.connection.setConnectTimeout(connectTimeout);
    }

    public LowLevelHttpResponse execute() throws IOException {
        HttpURLConnection connection = this.connection;
        if (this.content != null) {
            long contentLength;
            String contentEncoding;
            String contentType = this.content.getType();
            if (contentType != null) {
                this.addHeader("Content-Type", contentType);
            }
            if ((contentEncoding = this.content.getEncoding()) != null) {
                this.addHeader("Content-Encoding", contentEncoding);
            }
            if ((contentLength = this.content.getLength()) >= 0L) {
                this.addHeader("Content-Length", Long.toString(contentLength));
            }
            if (contentLength != 0L) {
                connection.setDoOutput(true);
                if (contentLength >= 0L && contentLength <= Integer.MAX_VALUE) {
                    connection.setFixedLengthStreamingMode((int)contentLength);
                } else {
                    connection.setChunkedStreamingMode(0);
                }
                this.content.writeTo(connection.getOutputStream());
            }
        }
        connection.connect();
        return new NetHttpResponse(connection);
    }

    public void setContent(HttpContent content) {
        this.content = content;
    }
}

