/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FutureCallable;
import com.google.api.gax.retrying.NonCancellableFuture;
import com.google.api.gax.retrying.RetryingFuture;
import io.grpc.CallOptions;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.threeten.bp.Duration;

class AttemptCallable<RequestT, ResponseT>
implements Callable<ResponseT> {
    private final FutureCallable<RequestT, ResponseT> callable;
    private final RequestT request;
    private volatile RetryingFuture<ResponseT> externalFuture;
    private volatile CallContext callContext;

    AttemptCallable(FutureCallable<RequestT, ResponseT> callable, RequestT request, CallContext callContext) {
        this.callable = callable;
        this.request = request;
        this.callContext = callContext;
    }

    public void setExternalFuture(RetryingFuture<ResponseT> externalFuture) {
        this.externalFuture = externalFuture;
    }

    @Override
    public ResponseT call() {
        try {
            if (this.callContext != null) {
                this.callContext = this.getNextCallContext(this.callContext, this.externalFuture.getAttemptSettings().getRpcTimeout());
            }
            this.externalFuture.setAttemptFuture((ApiFuture)new NonCancellableFuture());
            if (this.externalFuture.isDone()) {
                return null;
            }
            ApiFuture<ResponseT> internalFuture = this.callable.futureCall(this.request, this.callContext);
            this.externalFuture.setAttemptFuture(internalFuture);
        }
        catch (Throwable e) {
            this.externalFuture.setAttemptFuture(ApiFutures.immediateFailedFuture((Throwable)e));
        }
        return null;
    }

    private CallContext getNextCallContext(CallContext oldContext, Duration rpcTimeout) {
        CallOptions oldOptions = oldContext.getCallOptions();
        CallOptions newOptions = oldOptions.withDeadlineAfter(rpcTimeout.toMillis(), TimeUnit.MILLISECONDS);
        CallContext nextContext = oldContext.withCallOptions(newOptions);
        if (oldOptions.getDeadline() == null) {
            return nextContext;
        }
        if (oldOptions.getDeadline().isBefore(newOptions.getDeadline())) {
            return oldContext;
        }
        return nextContext;
    }
}

