/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.AuthInterceptor;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.HeaderInterceptor;
import com.google.auth.Credentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.grpc.CallCredentials;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@BetaApi
public final class InstantiatingChannelProvider
implements ChannelProvider {
    private static final String DEFAULT_VERSION = "";
    private static Properties gaxProperties = new Properties();
    private final ExecutorProvider executorProvider;
    private final CredentialsProvider credentialsProvider;
    private final String serviceAddress;
    private final int port;
    private final String clientLibName;
    private final String clientLibVersion;
    private final String generatorName;
    private final String generatorVersion;
    @Nullable
    private final Integer maxInboundMessageSize;

    private InstantiatingChannelProvider(ExecutorProvider executorProvider, CredentialsProvider credentialsProvider, String serviceAddress, int port, String clientLibName, String clientLibVersion, String generatorName, String generatorVersion, Integer maxInboundMessageSize) {
        this.executorProvider = executorProvider;
        this.credentialsProvider = credentialsProvider;
        this.serviceAddress = serviceAddress;
        this.port = port;
        this.clientLibName = clientLibName;
        this.clientLibVersion = clientLibVersion;
        this.generatorName = generatorName;
        this.generatorVersion = generatorVersion;
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    @Override
    public boolean needsExecutor() {
        return this.executorProvider == null;
    }

    @Override
    public ManagedChannel getChannel() throws IOException {
        if (this.needsExecutor()) {
            throw new IllegalStateException("getChannel() called when needsExecutor() is true");
        }
        return this.createChannel(this.executorProvider.getExecutor());
    }

    @Override
    public ManagedChannel getChannel(Executor executor) throws IOException {
        if (!this.needsExecutor()) {
            throw new IllegalStateException("getChannel(Executor) called when needsExecutor() is false");
        }
        return this.createChannel(executor);
    }

    private ManagedChannel createChannel(Executor executor) throws IOException {
        Credentials credentials;
        ArrayList interceptors = Lists.newArrayList();
        interceptors.add(new HeaderInterceptor(this.serviceHeader()));
        if (this.credentialsProvider != null && (credentials = this.credentialsProvider.getCredentials()) != null) {
            CallCredentials callCredentials = MoreCallCredentials.from((Credentials)credentials);
            interceptors.add(new AuthInterceptor(callCredentials));
        }
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)this.serviceAddress, (int)this.port).intercept((List)interceptors).executor(executor);
        if (this.maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(this.maxInboundMessageSize.intValue());
        }
        return builder.build();
    }

    @Deprecated
    public Credentials getCredentials() throws IOException {
        return this.getCredentialsProvider().getCredentials();
    }

    @Deprecated
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public String getEndpoint() {
        return this.serviceAddress + ':' + this.port;
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }

    @VisibleForTesting
    String serviceHeader() {
        if (this.clientLibName != null && this.clientLibVersion != null) {
            return String.format("gl-java/%s %s/%s %s/%s gax/%s grpc/%s", InstantiatingChannelProvider.getJavaVersion(), this.clientLibName, this.clientLibVersion, this.generatorName, this.generatorVersion, GaxProperties.getGaxVersion(), GaxGrpcProperties.getGrpcVersion());
        }
        return String.format("gl-java/%s %s/%s gax/%s grpc/%s", InstantiatingChannelProvider.getJavaVersion(), this.generatorName, this.generatorVersion, GaxProperties.getGaxVersion(), GaxGrpcProperties.getGrpcVersion());
    }

    private static String loadGaxProperty(String key) {
        try {
            if (gaxProperties.isEmpty()) {
                gaxProperties.load(InstantiatingChannelProvider.class.getResourceAsStream("/com/google/api/gax/gax.properties"));
            }
            return gaxProperties.getProperty(key);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private static String getJavaVersion() {
        String javaVersion = Runtime.class.getPackage().getImplementationVersion();
        if (javaVersion == null) {
            javaVersion = DEFAULT_VERSION;
        }
        return javaVersion;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private static final String DEFAULT_GENERATOR_NAME = "gapic";
        private ExecutorProvider executorProvider;
        private CredentialsProvider credentialsProvider;
        private String serviceAddress;
        private int port;
        private String clientLibName;
        private String clientLibVersion;
        private String generatorName;
        private String generatorVersion;
        private Integer maxInboundMessageSize;

        private Builder() {
            this.generatorName = DEFAULT_GENERATOR_NAME;
            this.generatorVersion = InstantiatingChannelProvider.DEFAULT_VERSION;
        }

        private Builder(InstantiatingChannelProvider provider) {
            this.credentialsProvider = provider.credentialsProvider;
            this.serviceAddress = provider.serviceAddress;
            this.port = provider.port;
            this.clientLibName = provider.clientLibName;
            this.clientLibVersion = provider.clientLibVersion;
            this.generatorName = provider.generatorName;
            this.generatorVersion = provider.generatorVersion;
            this.maxInboundMessageSize = provider.maxInboundMessageSize;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this;
        }

        @Deprecated
        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Deprecated
        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        public Builder setEndpoint(String endpoint) {
            int colon = endpoint.indexOf(58);
            if (colon < 0) {
                throw new IllegalArgumentException(String.format("invalid endpoint, expecting \"<host>:<port>\"", new Object[0]));
            }
            this.port = Integer.parseInt(endpoint.substring(colon + 1));
            this.serviceAddress = endpoint.substring(0, colon);
            return this;
        }

        public String getEndpoint() {
            return this.serviceAddress + ':' + this.port;
        }

        public Builder setGeneratorHeader(String name, String version) {
            this.generatorName = name;
            this.generatorVersion = version;
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            this.clientLibName = name;
            this.clientLibVersion = version;
            return this;
        }

        public String getClientLibName() {
            return this.clientLibName;
        }

        public String getClientLibVersion() {
            return this.clientLibVersion;
        }

        public String getGeneratorName() {
            return this.generatorName;
        }

        public String getGeneratorVersion() {
            return this.generatorVersion;
        }

        public Builder setMaxInboundMessageSize(Integer max) {
            this.maxInboundMessageSize = max;
            return this;
        }

        public Integer getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        public InstantiatingChannelProvider build() {
            return new InstantiatingChannelProvider(this.executorProvider, this.credentialsProvider, this.serviceAddress, this.port, this.clientLibName, this.clientLibVersion, this.generatorName, this.generatorVersion, this.maxInboundMessageSize);
        }
    }
}

