/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.CallOptionsUtil;
import com.google.common.collect.ImmutableMap;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Map;

class GrpcHeaderInterceptor
implements ClientInterceptor {
    private final Map<Metadata.Key<String>, String> staticHeaders;

    public GrpcHeaderInterceptor(Map<String, String> staticHeaders) {
        ImmutableMap.Builder grpcHeaders = ImmutableMap.builder();
        for (Map.Entry<String, String> header : staticHeaders.entrySet()) {
            grpcHeaders.put((Object)Metadata.Key.of((String)header.getKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)header.getValue());
        }
        this.staticHeaders = grpcHeaders.build();
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, Channel next) {
        ClientCall call = next.newCall(method, callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                for (Map.Entry staticHeader : GrpcHeaderInterceptor.this.staticHeaders.entrySet()) {
                    headers.put((Metadata.Key)staticHeader.getKey(), staticHeader.getValue());
                }
                Map<Metadata.Key<String>, String> dynamicHeaders = CallOptionsUtil.getDynamicHeadersOption(callOptions);
                for (Map.Entry<Metadata.Key<String>, String> dynamicHeader : dynamicHeaders.entrySet()) {
                    headers.put(dynamicHeader.getKey(), (Object)dynamicHeader.getValue());
                }
                super.start(responseListener, headers);
            }
        };
    }
}

