/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.iam.v1.KeyNameType;
import java.util.Map;

public class KeyName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/serviceAccounts/{service_account}/keys/{key}");
    private final String project;
    private final String serviceAccount;
    private final String key;

    public String getProject() {
        return this.project;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getKey() {
        return this.key;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private KeyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.serviceAccount = (String)Preconditions.checkNotNull((Object)builder.getServiceAccount());
        this.key = (String)Preconditions.checkNotNull((Object)builder.getKey());
    }

    public static KeyName create(String project, String serviceAccount, String key) {
        return KeyName.newBuilder().setProject(project).setServiceAccount(serviceAccount).setKey(key).build();
    }

    public static KeyName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "KeyName.parse: formattedString not in valid format");
        return KeyName.create((String)matchMap.get("project"), (String)matchMap.get("service_account"), (String)matchMap.get("key"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return KeyNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "service_account", this.serviceAccount, "key", this.key});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KeyName) {
            KeyName that = (KeyName)o;
            return this.project.equals(that.project) && this.serviceAccount.equals(that.serviceAccount) && this.key.equals(that.key);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.serviceAccount.hashCode();
        h *= 1000003;
        return h ^= this.key.hashCode();
    }

    public static class Builder {
        private String project;
        private String serviceAccount;
        private String key;

        public String getProject() {
            return this.project;
        }

        public String getServiceAccount() {
            return this.serviceAccount;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        private Builder() {
        }

        private Builder(KeyName keyName) {
            this.project = keyName.project;
            this.serviceAccount = keyName.serviceAccount;
            this.key = keyName.key;
        }

        public KeyName build() {
            return new KeyName(this);
        }
    }
}

