/*
 * Decompiled with CFR 0.152.
 */
package com.google.area120.tables.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.area120.tables.v1alpha.TablesServiceClient;
import com.google.area120.tables.v1alpha.stub.GrpcTablesServiceStub;
import com.google.area120.tables.v1alpha.stub.HttpJsonTablesServiceStub;
import com.google.area120.tables.v1alpha.stub.TablesServiceStub;
import com.google.area120.tables.v1alpha1.BatchCreateRowsRequest;
import com.google.area120.tables.v1alpha1.BatchCreateRowsResponse;
import com.google.area120.tables.v1alpha1.BatchDeleteRowsRequest;
import com.google.area120.tables.v1alpha1.BatchUpdateRowsRequest;
import com.google.area120.tables.v1alpha1.BatchUpdateRowsResponse;
import com.google.area120.tables.v1alpha1.CreateRowRequest;
import com.google.area120.tables.v1alpha1.DeleteRowRequest;
import com.google.area120.tables.v1alpha1.GetRowRequest;
import com.google.area120.tables.v1alpha1.GetTableRequest;
import com.google.area120.tables.v1alpha1.GetWorkspaceRequest;
import com.google.area120.tables.v1alpha1.ListRowsRequest;
import com.google.area120.tables.v1alpha1.ListRowsResponse;
import com.google.area120.tables.v1alpha1.ListTablesRequest;
import com.google.area120.tables.v1alpha1.ListTablesResponse;
import com.google.area120.tables.v1alpha1.ListWorkspacesRequest;
import com.google.area120.tables.v1alpha1.ListWorkspacesResponse;
import com.google.area120.tables.v1alpha1.Row;
import com.google.area120.tables.v1alpha1.Table;
import com.google.area120.tables.v1alpha1.UpdateRowRequest;
import com.google.area120.tables.v1alpha1.Workspace;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class TablesServiceStubSettings
extends StubSettings<TablesServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/drive").add((Object)"https://www.googleapis.com/auth/drive.file").add((Object)"https://www.googleapis.com/auth/drive.readonly").add((Object)"https://www.googleapis.com/auth/spreadsheets").add((Object)"https://www.googleapis.com/auth/spreadsheets.readonly").add((Object)"https://www.googleapis.com/auth/tables").build();
    private final UnaryCallSettings<GetTableRequest, Table> getTableSettings;
    private final PagedCallSettings<ListTablesRequest, ListTablesResponse, TablesServiceClient.ListTablesPagedResponse> listTablesSettings;
    private final UnaryCallSettings<GetWorkspaceRequest, Workspace> getWorkspaceSettings;
    private final PagedCallSettings<ListWorkspacesRequest, ListWorkspacesResponse, TablesServiceClient.ListWorkspacesPagedResponse> listWorkspacesSettings;
    private final UnaryCallSettings<GetRowRequest, Row> getRowSettings;
    private final PagedCallSettings<ListRowsRequest, ListRowsResponse, TablesServiceClient.ListRowsPagedResponse> listRowsSettings;
    private final UnaryCallSettings<CreateRowRequest, Row> createRowSettings;
    private final UnaryCallSettings<BatchCreateRowsRequest, BatchCreateRowsResponse> batchCreateRowsSettings;
    private final UnaryCallSettings<UpdateRowRequest, Row> updateRowSettings;
    private final UnaryCallSettings<BatchUpdateRowsRequest, BatchUpdateRowsResponse> batchUpdateRowsSettings;
    private final UnaryCallSettings<DeleteRowRequest, Empty> deleteRowSettings;
    private final UnaryCallSettings<BatchDeleteRowsRequest, Empty> batchDeleteRowsSettings;
    private static final PagedListDescriptor<ListTablesRequest, ListTablesResponse, Table> LIST_TABLES_PAGE_STR_DESC = new PagedListDescriptor<ListTablesRequest, ListTablesResponse, Table>(){

        public String emptyToken() {
            return "";
        }

        public ListTablesRequest injectToken(ListTablesRequest payload, String token) {
            return ListTablesRequest.newBuilder((ListTablesRequest)payload).setPageToken(token).build();
        }

        public ListTablesRequest injectPageSize(ListTablesRequest payload, int pageSize) {
            return ListTablesRequest.newBuilder((ListTablesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTablesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTablesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Table> extractResources(ListTablesResponse payload) {
            return payload.getTablesList() == null ? ImmutableList.of() : payload.getTablesList();
        }
    };
    private static final PagedListDescriptor<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> LIST_WORKSPACES_PAGE_STR_DESC = new PagedListDescriptor<ListWorkspacesRequest, ListWorkspacesResponse, Workspace>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkspacesRequest injectToken(ListWorkspacesRequest payload, String token) {
            return ListWorkspacesRequest.newBuilder((ListWorkspacesRequest)payload).setPageToken(token).build();
        }

        public ListWorkspacesRequest injectPageSize(ListWorkspacesRequest payload, int pageSize) {
            return ListWorkspacesRequest.newBuilder((ListWorkspacesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkspacesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkspacesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Workspace> extractResources(ListWorkspacesResponse payload) {
            return payload.getWorkspacesList() == null ? ImmutableList.of() : payload.getWorkspacesList();
        }
    };
    private static final PagedListDescriptor<ListRowsRequest, ListRowsResponse, Row> LIST_ROWS_PAGE_STR_DESC = new PagedListDescriptor<ListRowsRequest, ListRowsResponse, Row>(){

        public String emptyToken() {
            return "";
        }

        public ListRowsRequest injectToken(ListRowsRequest payload, String token) {
            return ListRowsRequest.newBuilder((ListRowsRequest)payload).setPageToken(token).build();
        }

        public ListRowsRequest injectPageSize(ListRowsRequest payload, int pageSize) {
            return ListRowsRequest.newBuilder((ListRowsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRowsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRowsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Row> extractResources(ListRowsResponse payload) {
            return payload.getRowsList() == null ? ImmutableList.of() : payload.getRowsList();
        }
    };
    private static final PagedListResponseFactory<ListTablesRequest, ListTablesResponse, TablesServiceClient.ListTablesPagedResponse> LIST_TABLES_PAGE_STR_FACT = new PagedListResponseFactory<ListTablesRequest, ListTablesResponse, TablesServiceClient.ListTablesPagedResponse>(){

        public ApiFuture<TablesServiceClient.ListTablesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTablesRequest, ListTablesResponse> callable, ListTablesRequest request, ApiCallContext context, ApiFuture<ListTablesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TABLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TablesServiceClient.ListTablesPagedResponse.createAsync((PageContext<ListTablesRequest, ListTablesResponse, Table>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListWorkspacesRequest, ListWorkspacesResponse, TablesServiceClient.ListWorkspacesPagedResponse> LIST_WORKSPACES_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkspacesRequest, ListWorkspacesResponse, TablesServiceClient.ListWorkspacesPagedResponse>(){

        public ApiFuture<TablesServiceClient.ListWorkspacesPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkspacesRequest, ListWorkspacesResponse> callable, ListWorkspacesRequest request, ApiCallContext context, ApiFuture<ListWorkspacesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKSPACES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TablesServiceClient.ListWorkspacesPagedResponse.createAsync((PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRowsRequest, ListRowsResponse, TablesServiceClient.ListRowsPagedResponse> LIST_ROWS_PAGE_STR_FACT = new PagedListResponseFactory<ListRowsRequest, ListRowsResponse, TablesServiceClient.ListRowsPagedResponse>(){

        public ApiFuture<TablesServiceClient.ListRowsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRowsRequest, ListRowsResponse> callable, ListRowsRequest request, ApiCallContext context, ApiFuture<ListRowsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROWS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TablesServiceClient.ListRowsPagedResponse.createAsync((PageContext<ListRowsRequest, ListRowsResponse, Row>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetTableRequest, Table> getTableSettings() {
        return this.getTableSettings;
    }

    public PagedCallSettings<ListTablesRequest, ListTablesResponse, TablesServiceClient.ListTablesPagedResponse> listTablesSettings() {
        return this.listTablesSettings;
    }

    public UnaryCallSettings<GetWorkspaceRequest, Workspace> getWorkspaceSettings() {
        return this.getWorkspaceSettings;
    }

    public PagedCallSettings<ListWorkspacesRequest, ListWorkspacesResponse, TablesServiceClient.ListWorkspacesPagedResponse> listWorkspacesSettings() {
        return this.listWorkspacesSettings;
    }

    public UnaryCallSettings<GetRowRequest, Row> getRowSettings() {
        return this.getRowSettings;
    }

    public PagedCallSettings<ListRowsRequest, ListRowsResponse, TablesServiceClient.ListRowsPagedResponse> listRowsSettings() {
        return this.listRowsSettings;
    }

    public UnaryCallSettings<CreateRowRequest, Row> createRowSettings() {
        return this.createRowSettings;
    }

    public UnaryCallSettings<BatchCreateRowsRequest, BatchCreateRowsResponse> batchCreateRowsSettings() {
        return this.batchCreateRowsSettings;
    }

    public UnaryCallSettings<UpdateRowRequest, Row> updateRowSettings() {
        return this.updateRowSettings;
    }

    public UnaryCallSettings<BatchUpdateRowsRequest, BatchUpdateRowsResponse> batchUpdateRowsSettings() {
        return this.batchUpdateRowsSettings;
    }

    public UnaryCallSettings<DeleteRowRequest, Empty> deleteRowSettings() {
        return this.deleteRowSettings;
    }

    public UnaryCallSettings<BatchDeleteRowsRequest, Empty> batchDeleteRowsSettings() {
        return this.batchDeleteRowsSettings;
    }

    public TablesServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTablesServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTablesServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "area120tables";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "area120tables.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "area120tables.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TablesServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TablesServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TablesServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return TablesServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TablesServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getTableSettings = settingsBuilder.getTableSettings().build();
        this.listTablesSettings = settingsBuilder.listTablesSettings().build();
        this.getWorkspaceSettings = settingsBuilder.getWorkspaceSettings().build();
        this.listWorkspacesSettings = settingsBuilder.listWorkspacesSettings().build();
        this.getRowSettings = settingsBuilder.getRowSettings().build();
        this.listRowsSettings = settingsBuilder.listRowsSettings().build();
        this.createRowSettings = settingsBuilder.createRowSettings().build();
        this.batchCreateRowsSettings = settingsBuilder.batchCreateRowsSettings().build();
        this.updateRowSettings = settingsBuilder.updateRowSettings().build();
        this.batchUpdateRowsSettings = settingsBuilder.batchUpdateRowsSettings().build();
        this.deleteRowSettings = settingsBuilder.deleteRowSettings().build();
        this.batchDeleteRowsSettings = settingsBuilder.batchDeleteRowsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TablesServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetTableRequest, Table> getTableSettings;
        private final PagedCallSettings.Builder<ListTablesRequest, ListTablesResponse, TablesServiceClient.ListTablesPagedResponse> listTablesSettings;
        private final UnaryCallSettings.Builder<GetWorkspaceRequest, Workspace> getWorkspaceSettings;
        private final PagedCallSettings.Builder<ListWorkspacesRequest, ListWorkspacesResponse, TablesServiceClient.ListWorkspacesPagedResponse> listWorkspacesSettings;
        private final UnaryCallSettings.Builder<GetRowRequest, Row> getRowSettings;
        private final PagedCallSettings.Builder<ListRowsRequest, ListRowsResponse, TablesServiceClient.ListRowsPagedResponse> listRowsSettings;
        private final UnaryCallSettings.Builder<CreateRowRequest, Row> createRowSettings;
        private final UnaryCallSettings.Builder<BatchCreateRowsRequest, BatchCreateRowsResponse> batchCreateRowsSettings;
        private final UnaryCallSettings.Builder<UpdateRowRequest, Row> updateRowSettings;
        private final UnaryCallSettings.Builder<BatchUpdateRowsRequest, BatchUpdateRowsResponse> batchUpdateRowsSettings;
        private final UnaryCallSettings.Builder<DeleteRowRequest, Empty> deleteRowSettings;
        private final UnaryCallSettings.Builder<BatchDeleteRowsRequest, Empty> batchDeleteRowsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTablesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TABLES_PAGE_STR_FACT);
            this.getWorkspaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWorkspacesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKSPACES_PAGE_STR_FACT);
            this.getRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRowsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROWS_PAGE_STR_FACT);
            this.createRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateRowsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateRowsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeleteRowsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTableSettings, this.listTablesSettings, this.getWorkspaceSettings, this.listWorkspacesSettings, this.getRowSettings, this.listRowsSettings, this.createRowSettings, this.batchCreateRowsSettings, this.updateRowSettings, this.batchUpdateRowsSettings, this.deleteRowSettings, this.batchDeleteRowsSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(TablesServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getTableSettings = settings.getTableSettings.toBuilder();
            this.listTablesSettings = settings.listTablesSettings.toBuilder();
            this.getWorkspaceSettings = settings.getWorkspaceSettings.toBuilder();
            this.listWorkspacesSettings = settings.listWorkspacesSettings.toBuilder();
            this.getRowSettings = settings.getRowSettings.toBuilder();
            this.listRowsSettings = settings.listRowsSettings.toBuilder();
            this.createRowSettings = settings.createRowSettings.toBuilder();
            this.batchCreateRowsSettings = settings.batchCreateRowsSettings.toBuilder();
            this.updateRowSettings = settings.updateRowSettings.toBuilder();
            this.batchUpdateRowsSettings = settings.batchUpdateRowsSettings.toBuilder();
            this.deleteRowSettings = settings.deleteRowSettings.toBuilder();
            this.batchDeleteRowsSettings = settings.batchDeleteRowsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTableSettings, this.listTablesSettings, this.getWorkspaceSettings, this.listWorkspacesSettings, this.getRowSettings, this.listRowsSettings, this.createRowSettings, this.batchCreateRowsSettings, this.updateRowSettings, this.batchUpdateRowsSettings, this.deleteRowSettings, this.batchDeleteRowsSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TablesServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TablesServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TablesServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TablesServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)TablesServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)TablesServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TablesServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TablesServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listTablesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getWorkspaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listWorkspacesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getRowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listRowsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createRowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.batchCreateRowsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateRowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.batchUpdateRowsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteRowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.batchDeleteRowsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetTableRequest, Table> getTableSettings() {
            return this.getTableSettings;
        }

        public PagedCallSettings.Builder<ListTablesRequest, ListTablesResponse, TablesServiceClient.ListTablesPagedResponse> listTablesSettings() {
            return this.listTablesSettings;
        }

        public UnaryCallSettings.Builder<GetWorkspaceRequest, Workspace> getWorkspaceSettings() {
            return this.getWorkspaceSettings;
        }

        public PagedCallSettings.Builder<ListWorkspacesRequest, ListWorkspacesResponse, TablesServiceClient.ListWorkspacesPagedResponse> listWorkspacesSettings() {
            return this.listWorkspacesSettings;
        }

        public UnaryCallSettings.Builder<GetRowRequest, Row> getRowSettings() {
            return this.getRowSettings;
        }

        public PagedCallSettings.Builder<ListRowsRequest, ListRowsResponse, TablesServiceClient.ListRowsPagedResponse> listRowsSettings() {
            return this.listRowsSettings;
        }

        public UnaryCallSettings.Builder<CreateRowRequest, Row> createRowSettings() {
            return this.createRowSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateRowsRequest, BatchCreateRowsResponse> batchCreateRowsSettings() {
            return this.batchCreateRowsSettings;
        }

        public UnaryCallSettings.Builder<UpdateRowRequest, Row> updateRowSettings() {
            return this.updateRowSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateRowsRequest, BatchUpdateRowsResponse> batchUpdateRowsSettings() {
            return this.batchUpdateRowsSettings;
        }

        public UnaryCallSettings.Builder<DeleteRowRequest, Empty> deleteRowSettings() {
            return this.deleteRowSettings;
        }

        public UnaryCallSettings.Builder<BatchDeleteRowsRequest, Empty> batchDeleteRowsSettings() {
            return this.batchDeleteRowsSettings;
        }

        public TablesServiceStubSettings build() throws IOException {
            return new TablesServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

