/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.VectoredReadOptions;

final class AutoValue_VectoredReadOptions
extends VectoredReadOptions {
    private final int minSeekVectoredReadSize;
    private final int mergeRangeMaxSize;
    private final int readThreads;

    private AutoValue_VectoredReadOptions(int minSeekVectoredReadSize, int mergeRangeMaxSize, int readThreads) {
        this.minSeekVectoredReadSize = minSeekVectoredReadSize;
        this.mergeRangeMaxSize = mergeRangeMaxSize;
        this.readThreads = readThreads;
    }

    @Override
    public int getMinSeekVectoredReadSize() {
        return this.minSeekVectoredReadSize;
    }

    @Override
    public int getMergeRangeMaxSize() {
        return this.mergeRangeMaxSize;
    }

    @Override
    public int getReadThreads() {
        return this.readThreads;
    }

    public String toString() {
        return "VectoredReadOptions{minSeekVectoredReadSize=" + this.minSeekVectoredReadSize + ", mergeRangeMaxSize=" + this.mergeRangeMaxSize + ", readThreads=" + this.readThreads + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VectoredReadOptions) {
            VectoredReadOptions that = (VectoredReadOptions)o;
            return this.minSeekVectoredReadSize == that.getMinSeekVectoredReadSize() && this.mergeRangeMaxSize == that.getMergeRangeMaxSize() && this.readThreads == that.getReadThreads();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.minSeekVectoredReadSize;
        h$ *= 1000003;
        h$ ^= this.mergeRangeMaxSize;
        h$ *= 1000003;
        return h$ ^= this.readThreads;
    }

    @Override
    public VectoredReadOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends VectoredReadOptions.Builder {
        private int minSeekVectoredReadSize;
        private int mergeRangeMaxSize;
        private int readThreads;
        private byte set$0;

        Builder() {
        }

        private Builder(VectoredReadOptions source) {
            this.minSeekVectoredReadSize = source.getMinSeekVectoredReadSize();
            this.mergeRangeMaxSize = source.getMergeRangeMaxSize();
            this.readThreads = source.getReadThreads();
            this.set$0 = (byte)7;
        }

        @Override
        public VectoredReadOptions.Builder setMinSeekVectoredReadSize(int minSeekVectoredReadSize) {
            this.minSeekVectoredReadSize = minSeekVectoredReadSize;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public VectoredReadOptions.Builder setMergeRangeMaxSize(int mergeRangeMaxSize) {
            this.mergeRangeMaxSize = mergeRangeMaxSize;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public VectoredReadOptions.Builder setReadThreads(int readThreads) {
            this.readThreads = readThreads;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public VectoredReadOptions build() {
            if (this.set$0 != 7) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" minSeekVectoredReadSize");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" mergeRangeMaxSize");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" readThreads");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_VectoredReadOptions(this.minSeekVectoredReadSize, this.mergeRangeMaxSize, this.readThreads);
        }
    }
}

