/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs.auth;

import com.google.cloud.hadoop.fs.gcs.DelegationTokenStatistics;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.auth.AbstractDelegationTokenBinding;
import com.google.cloud.hadoop.fs.gcs.auth.DelegationTokenIOException;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;

public class GcsDelegationTokens
extends AbstractService {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private GoogleHadoopFileSystem fileSystem;
    private final UserGroupInformation user = UserGroupInformation.getCurrentUser();
    private Text service;
    private AbstractDelegationTokenBinding tokenBinding;
    private AccessTokenProvider accessTokenProvider;
    private Token<DelegationTokenIdentifier> boundDT;

    public GcsDelegationTokens() throws IOException {
        super("GCSDelegationTokens");
    }

    public void serviceInit(Configuration conf) {
        String tokenBindingImpl = (String)GoogleHadoopFileSystemConfiguration.DELEGATION_TOKEN_BINDING_CLASS.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        Preconditions.checkState((tokenBindingImpl != null ? 1 : 0) != 0, (Object)"Delegation Tokens are not configured");
        try {
            Class<?> bindingClass = Class.forName(tokenBindingImpl);
            AbstractDelegationTokenBinding binding = (AbstractDelegationTokenBinding)((Object)bindingClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            binding.bindToFileSystem(this.fileSystem, this.getService());
            binding.init(conf);
            this.tokenBinding = binding;
            ((GoogleLogger.Api)logger.atFine()).log("Filesystem %s is using delegation tokens of kind %s", (Object)this.getService(), (Object)this.tokenBinding.getKind());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.tokenBinding.start();
        this.bindToAnyDelegationToken();
        ((GoogleLogger.Api)logger.atFiner()).log("GCS Delegation support token %s with %s", this.isBoundToDT() ? this.getBoundDT().decodeIdentifier() : "none", (Object)this.tokenBinding.getService());
    }

    protected void serviceStop() throws Exception {
        ((GoogleLogger.Api)logger.atFiner()).log("Stopping GCS delegation tokens");
        try {
            super.serviceStop();
        }
        finally {
            ServiceOperations.stopQuietly((Service)this.tokenBinding);
        }
    }

    public Text getService() {
        return this.service;
    }

    public AccessTokenProvider getAccessTokenProvider() {
        return this.accessTokenProvider;
    }

    public AccessTokenProvider deployUnbonded() throws IOException {
        Preconditions.checkState((!this.isBoundToDT() ? 1 : 0) != 0, (Object)"Already Bound to a delegation token");
        ((GoogleLogger.Api)logger.atFiner()).log("No delegation tokens present: using direct authentication");
        this.accessTokenProvider = this.tokenBinding.deployUnbonded();
        return this.accessTokenProvider;
    }

    public void bindToAnyDelegationToken() throws IOException {
        this.validateAccessTokenProvider();
        Token<DelegationTokenIdentifier> token = this.selectTokenFromFsOwner();
        if (token != null) {
            this.bindToDelegationToken(token);
        } else {
            this.deployUnbonded();
        }
        if (this.accessTokenProvider == null) {
            throw new DelegationTokenIOException("No AccessTokenProvider created by Delegation Token Binding " + this.tokenBinding.getKind());
        }
    }

    public Token<DelegationTokenIdentifier> selectTokenFromFsOwner() throws IOException {
        return GcsDelegationTokens.lookupToken(this.user.getCredentials(), this.service, this.tokenBinding.getKind());
    }

    public void bindToFileSystem(GoogleHadoopFileSystem fileSystem, Text service) {
        this.service = Objects.requireNonNull(service);
        this.fileSystem = Objects.requireNonNull(fileSystem);
    }

    public void bindToDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.validateAccessTokenProvider();
        this.boundDT = token;
        DelegationTokenIdentifier dti = GcsDelegationTokens.extractIdentifier(token);
        ((GoogleLogger.Api)logger.atInfo()).log("Using delegation token %s", (Object)dti);
        this.accessTokenProvider = this.tokenBinding.bindToTokenIdentifier(dti);
    }

    public boolean isBoundToDT() {
        return this.boundDT != null;
    }

    public Token<DelegationTokenIdentifier> getBoundDT() {
        return this.boundDT;
    }

    public Token<DelegationTokenIdentifier> getBoundOrNewDT(String renewer) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("Delegation token requested");
        if (this.isBoundToDT()) {
            ((GoogleLogger.Api)logger.atFine()).log("Returning current token");
            return this.getBoundDT();
        }
        return this.tokenBinding.createDelegationToken(renewer, this.getStats());
    }

    public static DelegationTokenIdentifier extractIdentifier(Token<? extends DelegationTokenIdentifier> token) throws IOException {
        DelegationTokenIdentifier identifier;
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"null token");
        try {
            identifier = (DelegationTokenIdentifier)token.decodeIdentifier();
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                throw new DelegationTokenIOException("Decoding GCS token " + cause, cause);
            }
            throw e;
        }
        if (identifier == null) {
            throw new DelegationTokenIOException("Failed to unmarshall token " + token);
        }
        return identifier;
    }

    private static Token<DelegationTokenIdentifier> lookupToken(Credentials credentials, Text service, Text kind) throws DelegationTokenIOException {
        ((GoogleLogger.Api)logger.atFiner()).log("Looking for token for service %s in credentials", (Object)service);
        Token token = credentials.getToken(service);
        if (token != null) {
            Text tokenKind = token.getKind();
            ((GoogleLogger.Api)logger.atFine()).log("Found token of kind %s", (Object)tokenKind);
            if (kind.equals((Object)tokenKind)) {
                return token;
            }
            throw DelegationTokenIOException.tokenMismatch(service, kind, tokenKind);
        }
        ((GoogleLogger.Api)logger.atFiner()).log("No token found for %s", (Object)service);
        return null;
    }

    private void validateAccessTokenProvider() {
        Preconditions.checkState((this.accessTokenProvider == null ? 1 : 0) != 0, (Object)"GCP Delegation tokens has already been bound/deployed");
    }

    private DelegationTokenStatistics getStats() {
        return this.fileSystem.getInstrumentation().newDelegationTokenStatistics();
    }
}

