/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingLevel;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggingHandler
extends Handler {
    private static final String HANDLERS_PROPERTY = "handlers";
    private static final String ROOT_LOGGER_NAME = "";
    private static final String[] NO_HANDLERS = new String[0];
    private static final Set<String> EXCLUDED_LOGGERS = ImmutableSet.of((Object)"io.grpc", (Object)"io.netty", (Object)"com.google.api.client.http", (Object)"sun.net.www.protocol.http");
    private final LoggingOptions options;
    private final List<LogEntry> buffer = new LinkedList<LogEntry>();
    private final Logging.WriteOption[] writeOptions;
    private Logging logging;
    private Level flushLevel;
    private long flushSize;

    public LoggingHandler() {
        this(null, null, null);
    }

    public LoggingHandler(String log) {
        this(log, null, null);
    }

    public LoggingHandler(String log, LoggingOptions options) {
        this(log, options, null);
    }

    public LoggingHandler(String log, LoggingOptions options, MonitoredResource monitoredResource) {
        LogConfigHelper helper = new LogConfigHelper();
        String className = this.getClass().getName();
        this.options = options != null ? options : LoggingOptions.defaultInstance();
        this.flushLevel = helper.getLevelProperty(className + ".flushLevel", LoggingLevel.ERROR);
        this.flushSize = helper.getLongProperty(className + ".flushSize", 1L);
        this.setLevel(helper.getLevelProperty(className + ".level", Level.INFO));
        this.setFilter(helper.getFilterProperty(className + ".filter", null));
        this.setFormatter(helper.getFormatterProperty(className + ".formatter", new SimpleFormatter()));
        String logName = (String)MoreObjects.firstNonNull((Object)log, (Object)helper.getProperty(className + ".log", "java.log"));
        MonitoredResource resource = (MonitoredResource)MoreObjects.firstNonNull((Object)monitoredResource, (Object)this.defaultResource());
        this.writeOptions = new Logging.WriteOption[]{Logging.WriteOption.logName(logName), Logging.WriteOption.resource(resource)};
        LoggingHandler.maskLoggers();
    }

    private static void maskLoggers() {
        for (String loggerName : EXCLUDED_LOGGERS) {
            Logger logger = Logger.getLogger(loggerName);
            List<LoggingHandler> loggingHandlers = LoggingHandler.getLoggingHandlers(logger);
            for (LoggingHandler loggingHandler : loggingHandlers) {
                logger.removeHandler(loggingHandler);
            }
            Logger currentLogger = logger;
            boolean masked = false;
            for (Logger ancestor = currentLogger.getParent(); ancestor != null && !masked; ancestor = ancestor.getParent()) {
                if (LoggingHandler.hasLoggingHandler(ancestor)) {
                    currentLogger.setUseParentHandlers(false);
                    masked = true;
                }
                currentLogger = ancestor;
            }
        }
    }

    private static List<LoggingHandler> getLoggingHandlers(Logger logger) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof LoggingHandler)) continue;
            builder.add((Object)((LoggingHandler)handler));
        }
        return builder.build();
    }

    private static boolean hasLoggingHandler(Logger logger) {
        String[] handlers;
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof LoggingHandler)) continue;
            return true;
        }
        String loggerName = logger.getName();
        String propertyName = loggerName.equals(ROOT_LOGGER_NAME) ? HANDLERS_PROPERTY : loggerName + "." + HANDLERS_PROPERTY;
        String handlersProperty = LogManager.getLogManager().getProperty(propertyName);
        for (String handlerName : handlers = handlersProperty != null ? handlersProperty.split(",") : NO_HANDLERS) {
            if (!handlerName.contains(LoggingHandler.class.getPackage().getName())) continue;
            return true;
        }
        return false;
    }

    private MonitoredResource defaultResource() {
        return MonitoredResource.of((String)"global", (Map)ImmutableMap.of((Object)"project_id", (Object)this.options.projectId()));
    }

    Logging logging() {
        if (this.logging == null) {
            this.logging = (Logging)this.options.service();
        }
        return this.logging;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        LogEntry entry = this.entryFor(record);
        if (entry != null) {
            this.buffer.add(entry);
        }
        if ((long)this.buffer.size() >= this.flushSize || record.getLevel().intValue() >= this.flushLevel.intValue()) {
            this.flush();
        }
    }

    private LogEntry entryFor(LogRecord record) {
        String payload;
        try {
            payload = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return null;
        }
        Level level = record.getLevel();
        ImmutableMap labels = ImmutableMap.of((Object)"levelName", (Object)level.getName(), (Object)"levelValue", (Object)String.valueOf(level.intValue()));
        return LogEntry.builder(Payload.StringPayload.of(payload)).labels((Map<String, String>)labels).severity(LoggingHandler.severityFor(level)).build();
    }

    private static Severity severityFor(Level level) {
        if (level instanceof LoggingLevel) {
            return ((LoggingLevel)level).severity();
        }
        switch (level.intValue()) {
            case 300: {
                return Severity.DEBUG;
            }
            case 400: {
                return Severity.DEBUG;
            }
            case 500: {
                return Severity.DEBUG;
            }
            case 700: {
                return Severity.INFO;
            }
            case 800: {
                return Severity.INFO;
            }
            case 900: {
                return Severity.WARNING;
            }
            case 1000: {
                return Severity.ERROR;
            }
        }
        return Severity.DEFAULT;
    }

    void write(List<LogEntry> entries, Logging.WriteOption ... options) {
        this.logging().write(entries, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() {
        try {
            this.write(this.buffer, this.writeOptions);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 2);
        }
        finally {
            this.buffer.clear();
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        if (this.logging != null) {
            try {
                this.logging.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logging = null;
    }

    public synchronized Level setFlushLevel(Level flushLevel) {
        this.flushLevel = flushLevel;
        return flushLevel;
    }

    public synchronized long setFlushSize(long flushSize) {
        this.flushSize = flushSize;
        return flushSize;
    }

    public static void addHandler(Logger logger, LoggingHandler handler) {
        logger.addHandler(handler);
        LoggingHandler.maskLoggers();
    }

    private static class LogConfigHelper {
        private final LogManager manager = LogManager.getLogManager();

        private LogConfigHelper() {
        }

        String getProperty(String name, String defaultValue) {
            return (String)MoreObjects.firstNonNull((Object)this.manager.getProperty(name), (Object)defaultValue);
        }

        long getLongProperty(String name, long defaultValue) {
            try {
                return Long.parseLong(this.manager.getProperty(name));
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }

        Level getLevelProperty(String name, Level defaultValue) {
            String stringLevel = this.manager.getProperty(name);
            if (stringLevel == null) {
                return defaultValue;
            }
            try {
                return Level.parse(stringLevel);
            }
            catch (IllegalArgumentException ex) {
                return defaultValue;
            }
        }

        Filter getFilterProperty(String name, Filter defaultValue) {
            String stringFilter = this.manager.getProperty(name);
            try {
                if (stringFilter != null) {
                    Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(stringFilter);
                    return (Filter)clz.newInstance();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return defaultValue;
        }

        Formatter getFormatterProperty(String name, Formatter defaultValue) {
            String stringFilter = this.manager.getProperty(name);
            try {
                if (stringFilter != null) {
                    Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(stringFilter);
                    return (Formatter)clz.newInstance();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return defaultValue;
        }
    }
}

