/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2.testing;

import com.google.cloud.logging.spi.v2.testing.LocalLoggingImpl;
import com.google.logging.v2.LoggingServiceV2Grpc;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import java.io.IOException;
import java.net.SocketAddress;

public class LocalLoggingHelper {
    private static final int FLOW_CONTROL_WINDOW = 66560;
    private final SocketAddress address;
    private final Server server;
    private final LocalLoggingImpl loggingImpl;

    public LocalLoggingHelper(String addressString) {
        this.address = new LocalAddress(addressString);
        this.loggingImpl = new LocalLoggingImpl();
        NettyServerBuilder builder = NettyServerBuilder.forAddress((SocketAddress)this.address).flowControlWindow(66560).channelType(LocalServerChannel.class);
        builder.addService(LoggingServiceV2Grpc.bindService((LoggingServiceV2Grpc.LoggingServiceV2)this.loggingImpl));
        this.server = builder.build();
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void reset() {
        this.loggingImpl.reset();
    }

    public LocalLoggingImpl getLoggingImpl() {
        return this.loggingImpl;
    }

    public ManagedChannel createChannel() {
        return NettyChannelBuilder.forAddress((SocketAddress)this.address).negotiationType(NegotiationType.PLAINTEXT).channelType(LocalChannel.class).build();
    }

    public void shutdownNow() {
        this.server.shutdownNow();
    }
}

