/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;

public final class ExceptionHandler
implements Serializable {
    private static final long serialVersionUID = -2460707015779532919L;
    private static final ExceptionHandler DEFAULT_INSTANCE = ExceptionHandler.newBuilder().retryOn(Exception.class).abortOn(RuntimeException.class).build();
    private final ImmutableList<Interceptor> interceptors;
    private final ImmutableSet<Class<? extends Exception>> retriableExceptions;
    private final ImmutableSet<Class<? extends Exception>> nonRetriableExceptions;
    private final Set<RetryInfo> retryInfo = Sets.newHashSet();

    private ExceptionHandler(Builder builder) {
        this.interceptors = builder.interceptors.build();
        this.retriableExceptions = builder.retriableExceptions.build();
        this.nonRetriableExceptions = builder.nonRetriableExceptions.build();
        Preconditions.checkArgument((boolean)Sets.intersection(this.retriableExceptions, this.nonRetriableExceptions).isEmpty(), (Object)"Same exception was found in both retryable and non-retryable sets");
        for (Class exception : this.retriableExceptions) {
            ExceptionHandler.addRetryInfo(new RetryInfo(exception, Interceptor.RetryResult.RETRY), this.retryInfo);
        }
        for (Class exception : this.nonRetriableExceptions) {
            ExceptionHandler.addRetryInfo(new RetryInfo(exception, Interceptor.RetryResult.NO_RETRY), this.retryInfo);
        }
    }

    private static void addRetryInfo(RetryInfo retryInfo, Set<RetryInfo> dest) {
        for (RetryInfo current : dest) {
            if (current.exception.isAssignableFrom(retryInfo.exception)) {
                ExceptionHandler.addRetryInfo(retryInfo, current.children);
                return;
            }
            if (!retryInfo.exception.isAssignableFrom(current.exception)) continue;
            retryInfo.children.add(current);
        }
        dest.removeAll(retryInfo.children);
        dest.add(retryInfo);
    }

    private static RetryInfo findMostSpecificRetryInfo(Set<RetryInfo> retryInfo, Class<? extends Exception> exception) {
        for (RetryInfo current : retryInfo) {
            if (!current.exception.isAssignableFrom(exception)) continue;
            RetryInfo match = ExceptionHandler.findMostSpecificRetryInfo(current.children, exception);
            return match == null ? current : match;
        }
        return null;
    }

    private static Method getCallableMethod(Class<?> clazz) {
        try {
            return clazz.getDeclaredMethod("call", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return ExceptionHandler.getCallableMethod(clazz.getSuperclass());
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    void verifyCaller(Callable<?> callable) {
        Method callMethod = ExceptionHandler.getCallableMethod(callable.getClass());
        for (Class<?> exceptionOrError : callMethod.getExceptionTypes()) {
            Preconditions.checkArgument((boolean)Exception.class.isAssignableFrom(exceptionOrError), (Object)"Callable method exceptions must be derived from Exception");
            Class<?> exception = exceptionOrError;
            Preconditions.checkArgument((ExceptionHandler.findMostSpecificRetryInfo(this.retryInfo, exception) != null ? 1 : 0) != 0, (Object)("Declared exception '" + exception + "' is not covered by exception handler"));
        }
    }

    public Set<Class<? extends Exception>> getRetriableExceptions() {
        return this.retriableExceptions;
    }

    public Set<Class<? extends Exception>> getNonRetriableExceptions() {
        return this.nonRetriableExceptions;
    }

    boolean shouldRetry(Exception ex) {
        for (Interceptor interceptor : this.interceptors) {
            Interceptor.RetryResult retryResult = (Interceptor.RetryResult)((Object)Preconditions.checkNotNull((Object)((Object)interceptor.beforeEval(ex))));
            if (retryResult == Interceptor.RetryResult.CONTINUE_EVALUATION) continue;
            return retryResult == Interceptor.RetryResult.RETRY;
        }
        RetryInfo retryInfo = ExceptionHandler.findMostSpecificRetryInfo(this.retryInfo, ex.getClass());
        Interceptor.RetryResult retryResult = retryInfo == null ? Interceptor.RetryResult.NO_RETRY : retryInfo.retry;
        for (Interceptor interceptor : this.interceptors) {
            Interceptor.RetryResult interceptorRetry = (Interceptor.RetryResult)((Object)Preconditions.checkNotNull((Object)((Object)interceptor.afterEval(ex, retryResult))));
            if (interceptorRetry == Interceptor.RetryResult.CONTINUE_EVALUATION) continue;
            retryResult = interceptorRetry;
        }
        return retryResult == Interceptor.RetryResult.RETRY;
    }

    public int hashCode() {
        return Objects.hash(this.interceptors, this.retriableExceptions, this.nonRetriableExceptions, this.retryInfo);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExceptionHandler)) {
            return false;
        }
        ExceptionHandler other = (ExceptionHandler)obj;
        return Objects.equals(this.interceptors, other.interceptors) && Objects.equals(this.retriableExceptions, other.retriableExceptions) && Objects.equals(this.nonRetriableExceptions, other.nonRetriableExceptions) && Objects.equals(this.retryInfo, other.retryInfo);
    }

    public static ExceptionHandler getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @VisibleForTesting
    static final class RetryInfo
    implements Serializable {
        private static final long serialVersionUID = -4264634837841455974L;
        private final Class<? extends Exception> exception;
        private final Interceptor.RetryResult retry;
        private final Set<RetryInfo> children = Sets.newHashSet();

        RetryInfo(Class<? extends Exception> exception, Interceptor.RetryResult retry) {
            this.exception = (Class)Preconditions.checkNotNull(exception);
            this.retry = (Interceptor.RetryResult)((Object)Preconditions.checkNotNull((Object)((Object)retry)));
        }

        public int hashCode() {
            return this.exception.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RetryInfo)) {
                return false;
            }
            return ((RetryInfo)obj).exception.equals(this.exception);
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<Interceptor> interceptors = ImmutableList.builder();
        private final ImmutableSet.Builder<Class<? extends Exception>> retriableExceptions = ImmutableSet.builder();
        private final ImmutableSet.Builder<Class<? extends Exception>> nonRetriableExceptions = ImmutableSet.builder();

        private Builder() {
        }

        public Builder addInterceptors(Interceptor ... interceptors) {
            for (Interceptor interceptor : interceptors) {
                this.interceptors.add((Object)interceptor);
            }
            return this;
        }

        @SafeVarargs
        public final Builder retryOn(Class<? extends Exception> ... exceptions) {
            for (Class<? extends Exception> exception : exceptions) {
                this.retriableExceptions.add(Preconditions.checkNotNull(exception));
            }
            return this;
        }

        @SafeVarargs
        public final Builder abortOn(Class<? extends Exception> ... exceptions) {
            for (Class<? extends Exception> exception : exceptions) {
                this.nonRetriableExceptions.add(Preconditions.checkNotNull(exception));
            }
            return this;
        }

        public ExceptionHandler build() {
            return new ExceptionHandler(this);
        }
    }

    public static interface Interceptor
    extends Serializable {
        public RetryResult beforeEval(Exception var1);

        public RetryResult afterEval(Exception var1, RetryResult var2);

        public static enum RetryResult {
            NO_RETRY,
            RETRY,
            CONTINUE_EVALUATION;

        }
    }
}

