/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.RetryParams;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import io.grpc.internal.SharedResourceHolder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joda.time.Duration;

public class GrpcTransportOptions
implements TransportOptions {
    private static final long serialVersionUID = -9049538465533951165L;
    private final String executorFactoryClassName;
    private final int initialTimeout;
    private final double timeoutMultiplier;
    private final int maxTimeout;
    private transient ExecutorFactory<ScheduledExecutorService> executorFactory;
    private static final SharedResourceHolder.Resource<ScheduledExecutorService> EXECUTOR = new SharedResourceHolder.Resource<ScheduledExecutorService>(){

        public ScheduledExecutorService create() {
            ScheduledThreadPoolExecutor service = new ScheduledThreadPoolExecutor(8);
            service.setKeepAliveTime(5L, TimeUnit.SECONDS);
            service.allowCoreThreadTimeOut(true);
            service.setRemoveOnCancelPolicy(true);
            return service;
        }

        public void close(ScheduledExecutorService instance) {
            instance.shutdown();
        }
    };

    private GrpcTransportOptions(Builder builder) {
        this.executorFactory = (ExecutorFactory)MoreObjects.firstNonNull((Object)builder.executorFactory, (Object)ServiceOptions.getFromServiceLoader(ExecutorFactory.class, DefaultExecutorFactory.INSTANCE));
        this.executorFactoryClassName = this.executorFactory.getClass().getName();
        this.initialTimeout = builder.initialTimeout;
        this.timeoutMultiplier = builder.timeoutMultiplier;
        this.maxTimeout = builder.maxTimeout <= this.initialTimeout ? this.initialTimeout : builder.maxTimeout;
    }

    public ExecutorFactory<ScheduledExecutorService> getExecutorFactory() {
        return this.executorFactory;
    }

    public UnaryCallSettings.Builder getApiCallSettings(RetryParams retryParams) {
        RetrySettings.Builder builder = RetrySettings.newBuilder().setTotalTimeout(Duration.millis((long)retryParams.getTotalRetryPeriodMillis())).setInitialRpcTimeout(Duration.millis((long)this.getInitialTimeout())).setRpcTimeoutMultiplier(this.getTimeoutMultiplier()).setMaxRpcTimeout(Duration.millis((long)this.getMaxTimeout())).setInitialRetryDelay(Duration.millis((long)retryParams.getInitialRetryDelayMillis())).setRetryDelayMultiplier(retryParams.getRetryDelayBackoffFactor()).setMaxRetryDelay(Duration.millis((long)retryParams.getMaxRetryDelayMillis()));
        return UnaryCallSettings.newBuilder().setRetrySettingsBuilder(builder);
    }

    public static ChannelProvider getChannelProvider(ServiceOptions<?, ?, ?> serviceOptions) {
        HostAndPort hostAndPort = HostAndPort.fromString((String)serviceOptions.getHost());
        InstantiatingChannelProvider.Builder builder = InstantiatingChannelProvider.newBuilder().setServiceAddress(hostAndPort.getHostText()).setPort(hostAndPort.getPort()).setClientLibHeader(serviceOptions.getGoogApiClientLibName(), (String)MoreObjects.firstNonNull((Object)serviceOptions.getLibraryVersion(), (Object)""));
        Credentials scopedCredentials = serviceOptions.getScopedCredentials();
        if (scopedCredentials != null && scopedCredentials != NoCredentials.getInstance()) {
            builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)scopedCredentials));
        }
        return builder.build();
    }

    public int getInitialTimeout() {
        return this.initialTimeout;
    }

    public double getTimeoutMultiplier() {
        return this.timeoutMultiplier;
    }

    public int getMaxTimeout() {
        return this.maxTimeout;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return Objects.hash(this.executorFactoryClassName, this.initialTimeout, this.timeoutMultiplier, this.maxTimeout);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GrpcTransportOptions other = (GrpcTransportOptions)obj;
        return Objects.equals(this.executorFactoryClassName, other.executorFactoryClassName) && Objects.equals(this.initialTimeout, other.initialTimeout) && Objects.equals(this.timeoutMultiplier, other.timeoutMultiplier) && Objects.equals(this.maxTimeout, other.maxTimeout);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.executorFactory = (ExecutorFactory)ServiceOptions.newInstance(this.executorFactoryClassName);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ExecutorFactory executorFactory;
        private int initialTimeout = 20000;
        private double timeoutMultiplier = 1.5;
        private int maxTimeout = 100000;

        private Builder() {
        }

        private Builder(GrpcTransportOptions options) {
            this.executorFactory = options.executorFactory;
            this.initialTimeout = options.initialTimeout;
            this.timeoutMultiplier = options.timeoutMultiplier;
            this.maxTimeout = options.maxTimeout;
        }

        public GrpcTransportOptions build() {
            return new GrpcTransportOptions(this);
        }

        public Builder setExecutorFactory(ExecutorFactory<ScheduledExecutorService> executorFactory) {
            this.executorFactory = executorFactory;
            return this;
        }

        public Builder setInitialTimeout(int initialTimeout) {
            Preconditions.checkArgument((initialTimeout > 0 ? 1 : 0) != 0, (Object)"Initial timeout must be > 0");
            this.initialTimeout = initialTimeout;
            return this;
        }

        public Builder setTimeoutMultiplier(double timeoutMultiplier) {
            Preconditions.checkArgument((timeoutMultiplier >= 1.0 ? 1 : 0) != 0, (Object)"Timeout multiplier must be >= 1");
            this.timeoutMultiplier = timeoutMultiplier;
            return this;
        }

        public Builder setMaxTimeout(int maxTimeout) {
            this.maxTimeout = maxTimeout;
            return this;
        }
    }

    @VisibleForTesting
    static class DefaultExecutorFactory
    implements ExecutorFactory<ScheduledExecutorService> {
        private static final DefaultExecutorFactory INSTANCE = new DefaultExecutorFactory();

        DefaultExecutorFactory() {
        }

        @Override
        public ScheduledExecutorService get() {
            return (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)EXECUTOR);
        }

        @Override
        public synchronized void release(ScheduledExecutorService executor) {
            SharedResourceHolder.release((SharedResourceHolder.Resource)EXECUTOR, (Object)executor);
        }
    }

    public static interface ExecutorFactory<T extends ExecutorService> {
        public T get();

        public void release(T var1);
    }
}

