/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.BaseServiceException;
import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;

public abstract class BatchResult<T, E extends BaseServiceException> {
    private T result;
    private boolean completed = false;
    private E error;
    private final List<Callback<T, E>> toBeNotified = new LinkedList<Callback<T, E>>();

    public boolean completed() {
        return this.completed;
    }

    public T get() throws E {
        Preconditions.checkState((boolean)this.completed(), (Object)"Batch has not been completed yet");
        if (this.error != null) {
            throw this.error;
        }
        return this.result;
    }

    public void notify(Callback<T, E> callback) {
        Preconditions.checkState((!this.completed ? 1 : 0) != 0, (Object)"The batch has been completed. All the calls to the notify() method should be done prior to submitting the batch.");
        this.toBeNotified.add(callback);
    }

    protected void error(E error) {
        this.error = (BaseServiceException)Preconditions.checkNotNull(error);
        this.completed = true;
        for (Callback<T, E> callback : this.toBeNotified) {
            callback.error(error);
        }
    }

    protected void success(T result) {
        this.result = result;
        this.completed = true;
        for (Callback<T, E> callback : this.toBeNotified) {
            callback.success(result);
        }
    }

    public static interface Callback<T, E> {
        public void success(T var1);

        public void error(E var1);
    }
}

