/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.GcpLaunchStage;
import com.google.cloud.datastore.RawValue;
import com.google.cloud.datastore.ValueBuilder;
import com.google.cloud.datastore.ValueMarshaller;
import com.google.cloud.datastore.ValueType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.datastore.v1.Value;
import java.io.Serializable;
import java.util.Objects;

public abstract class Value<V>
implements Serializable {
    private static final long serialVersionUID = 8532411152601335280L;
    private final ValueType valueType;
    private final boolean excludeFromIndexes;
    private final int meaning;
    private final V value;

    <P extends Value<V>, B extends BaseBuilder<V, P, B>> Value(ValueBuilder<V, P, B> builder) {
        this.valueType = builder.getValueType();
        this.excludeFromIndexes = builder.getExcludeFromIndexes();
        this.meaning = builder.getMeaning();
        this.value = builder.get();
    }

    public final ValueType getType() {
        return this.valueType;
    }

    public final boolean excludeFromIndexes() {
        return this.excludeFromIndexes;
    }

    @GcpLaunchStage.Deprecated
    final int getMeaning() {
        return this.meaning;
    }

    public final V get() {
        return this.value;
    }

    public abstract ValueBuilder<?, ?, ?> toBuilder();

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("valueType", (Object)this.valueType).add("excludeFromIndexes", this.excludeFromIndexes).add("meaning", this.meaning).add("value", this.value).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.valueType, this.excludeFromIndexes, this.meaning, this.value});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        Value other = (Value)obj;
        return Objects.equals((Object)this.valueType, (Object)other.valueType) && Objects.equals(this.excludeFromIndexes, other.excludeFromIndexes) && Objects.equals(this.meaning, other.meaning) && Objects.equals(this.value, other.value);
    }

    com.google.datastore.v1.Value toPb() {
        return this.getType().getMarshaller().toProto(this);
    }

    public static Value<?> fromPb(com.google.datastore.v1.Value proto) {
        Value.ValueTypeCase descriptorId = proto.getValueTypeCase();
        ValueType valueType = ValueType.getByDescriptorId(descriptorId.getNumber());
        return valueType == null ? RawValue.MARSHALLER.fromProto(proto).build() : valueType.getMarshaller().fromProto(proto).build();
    }

    static abstract class BaseBuilder<V, P extends Value<V>, B extends BaseBuilder<V, P, B>>
    implements ValueBuilder<V, P, B> {
        private final ValueType valueType;
        private boolean excludeFromIndexes;
        private int meaning;
        private V value;

        BaseBuilder(ValueType valueType) {
            this.valueType = valueType;
        }

        @Override
        public ValueType getValueType() {
            return this.valueType;
        }

        @Override
        public B mergeFrom(P other) {
            this.excludeFromIndexes = ((Value)other).excludeFromIndexes();
            this.meaning = ((Value)other).getMeaning();
            this.set(((Value)other).get());
            return this.self();
        }

        @Override
        public boolean getExcludeFromIndexes() {
            return this.excludeFromIndexes;
        }

        @Override
        public B setExcludeFromIndexes(boolean excludeFromIndexes) {
            this.excludeFromIndexes = excludeFromIndexes;
            return this.self();
        }

        @Override
        @GcpLaunchStage.Deprecated
        public int getMeaning() {
            return this.meaning;
        }

        @Override
        @GcpLaunchStage.Deprecated
        public B setMeaning(int meaning) {
            this.meaning = meaning;
            return this.self();
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public B set(V value) {
            this.value = Preconditions.checkNotNull(value);
            return this.self();
        }

        private B self() {
            return (B)this;
        }

        @Override
        public abstract P build();
    }

    static abstract class BaseMarshaller<V, P extends Value<V>, B extends ValueBuilder<V, P, B>>
    implements ValueMarshaller<V, P, B>,
    BuilderFactory<V, P, B> {
        private static final long serialVersionUID = -5224067974180563797L;

        @Override
        public final B fromProto(com.google.datastore.v1.Value proto) {
            Object builder = this.newBuilder(this.getValue(proto));
            builder.setExcludeFromIndexes(proto.getExcludeFromIndexes());
            builder.setMeaning(proto.getMeaning());
            return builder;
        }

        @Override
        public final com.google.datastore.v1.Value toProto(P value) {
            Value.Builder builder = com.google.datastore.v1.Value.newBuilder();
            builder.setExcludeFromIndexes(((Value)value).excludeFromIndexes());
            builder.setMeaning(((Value)value).getMeaning());
            this.setValue(value, builder);
            return builder.build();
        }

        BaseMarshaller() {
        }

        protected abstract V getValue(com.google.datastore.v1.Value var1);

        protected abstract void setValue(P var1, Value.Builder var2);
    }

    static interface BuilderFactory<V, P extends Value<V>, B extends ValueBuilder<V, P, B>>
    extends Serializable {
        public B newBuilder(V var1);
    }
}

