/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.spi.v1;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.cloud.ServiceOptions;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.spi.v1.DatastoreRpc;
import com.google.cloud.http.HttpTransportOptions;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.datastore.v1.client.Datastore;
import com.google.datastore.v1.client.DatastoreFactory;
import com.google.datastore.v1.client.DatastoreOptions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;

public class HttpDatastoreRpc
implements DatastoreRpc {
    private final Datastore client;

    public HttpDatastoreRpc(DatastoreOptions options) {
        String normalizedHost;
        HttpTransportOptions httpTransportOptions = (HttpTransportOptions)options.getTransportOptions();
        HttpTransport transport = httpTransportOptions.getHttpTransportFactory().create();
        DatastoreOptions.Builder clientBuilder = new DatastoreOptions.Builder().projectId(options.getProjectId()).initializer(this.getHttpRequestInitializer(options, httpTransportOptions)).transport(transport);
        String string = normalizedHost = options.getHost() != null ? options.getHost().toLowerCase() : "";
        if (HttpDatastoreRpc.isLocalHost(normalizedHost)) {
            clientBuilder = clientBuilder.localHost(HttpDatastoreRpc.removeScheme(normalizedHost));
        } else if (!HttpDatastoreRpc.removeScheme("https://datastore.googleapis.com").equals(HttpDatastoreRpc.removeScheme(normalizedHost)) && !normalizedHost.isEmpty()) {
            String fullUrl = normalizedHost;
            if (fullUrl.charAt(fullUrl.length() - 1) != '/') {
                fullUrl = fullUrl + '/';
            }
            fullUrl = fullUrl + "v1" + "/projects/" + options.getProjectId();
            clientBuilder = clientBuilder.projectId(null).projectEndpoint(fullUrl);
        }
        this.client = DatastoreFactory.get().create(clientBuilder.build());
    }

    private HttpRequestInitializer getHttpRequestInitializer(DatastoreOptions options, HttpTransportOptions httpTransportOptions) {
        final HttpRequestInitializer delegate = httpTransportOptions.getHttpRequestInitializer((ServiceOptions)options);
        final String applicationName = options.getApplicationName();
        return new HttpRequestInitializer(){

            public void initialize(HttpRequest httpRequest) throws IOException {
                delegate.initialize(httpRequest);
                httpRequest.getHeaders().setUserAgent(applicationName);
            }
        };
    }

    private static boolean isLocalHost(String host) {
        if (!host.isEmpty()) {
            try {
                String normalizedHost = "http://" + HttpDatastoreRpc.removeScheme(host);
                InetAddress hostAddr = InetAddress.getByName(new URL(normalizedHost).getHost());
                return hostAddr.isAnyLocalAddress() || hostAddr.isLoopbackAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static String removeScheme(String url) {
        if (url != null) {
            if (url.startsWith("https://")) {
                return url.substring("https://".length());
            }
            if (url.startsWith("http://")) {
                return url.substring("http://".length());
            }
        }
        return url;
    }

    private static DatastoreException translate(com.google.datastore.v1.client.DatastoreException exception) {
        return HttpDatastoreRpc.translate(exception, true);
    }

    private static DatastoreException translate(com.google.datastore.v1.client.DatastoreException exception, boolean idempotent) {
        String reason = "";
        if (exception.getCode() != null) {
            reason = exception.getCode().name();
        }
        if (reason.isEmpty() && exception.getCause() instanceof IOException) {
            return new DatastoreException((IOException)exception.getCause());
        }
        return new DatastoreException(exception.getCode().getNumber(), exception.getMessage(), reason, idempotent, exception);
    }

    @Override
    public AllocateIdsResponse allocateIds(AllocateIdsRequest request) {
        try {
            return this.client.allocateIds(request);
        }
        catch (com.google.datastore.v1.client.DatastoreException ex) {
            throw HttpDatastoreRpc.translate(ex);
        }
    }

    @Override
    public BeginTransactionResponse beginTransaction(BeginTransactionRequest request) {
        try {
            return this.client.beginTransaction(request);
        }
        catch (com.google.datastore.v1.client.DatastoreException ex) {
            throw HttpDatastoreRpc.translate(ex);
        }
    }

    @Override
    public CommitResponse commit(CommitRequest request) {
        try {
            return this.client.commit(request);
        }
        catch (com.google.datastore.v1.client.DatastoreException ex) {
            throw HttpDatastoreRpc.translate(ex, request.getMode() == CommitRequest.Mode.NON_TRANSACTIONAL);
        }
    }

    @Override
    public LookupResponse lookup(LookupRequest request) {
        try {
            return this.client.lookup(request);
        }
        catch (com.google.datastore.v1.client.DatastoreException ex) {
            throw HttpDatastoreRpc.translate(ex);
        }
    }

    @Override
    public ReserveIdsResponse reserveIds(ReserveIdsRequest request) {
        try {
            return this.client.reserveIds(request);
        }
        catch (com.google.datastore.v1.client.DatastoreException ex) {
            throw HttpDatastoreRpc.translate(ex);
        }
    }

    @Override
    public RollbackResponse rollback(RollbackRequest request) {
        try {
            return this.client.rollback(request);
        }
        catch (com.google.datastore.v1.client.DatastoreException ex) {
            throw HttpDatastoreRpc.translate(ex);
        }
    }

    @Override
    public RunQueryResponse runQuery(RunQueryRequest request) {
        try {
            return this.client.runQuery(request);
        }
        catch (com.google.datastore.v1.client.DatastoreException ex) {
            throw HttpDatastoreRpc.translate(ex);
        }
    }
}

