/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.LoggingEnhancer;

public class TraceLoggingEnhancer
implements LoggingEnhancer {
    private static final ThreadLocal<String> traceId = new ThreadLocal();

    public TraceLoggingEnhancer() {
    }

    public TraceLoggingEnhancer(String prefix) {
    }

    public static void setCurrentTraceId(String id) {
        if (id == null) {
            traceId.remove();
        } else {
            traceId.set(id);
        }
    }

    public static String getCurrentTraceId() {
        return traceId.get();
    }

    @Override
    public void enhanceLogEntry(LogEntry.Builder builder) {
        String traceId = TraceLoggingEnhancer.getCurrentTraceId();
        if (traceId != null) {
            builder.setTrace(traceId);
        }
    }
}

