/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.RequestBuilder;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.BatchedRequestIssuer;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.stub.GrpcPublisherStub;
import com.google.cloud.pubsub.v1.stub.HttpJsonPublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.DetachSubscriptionRequest;
import com.google.pubsub.v1.DetachSubscriptionResponse;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSnapshotsRequest;
import com.google.pubsub.v1.ListTopicSnapshotsResponse;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.UpdateTopicRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class PublisherStubSettings
extends StubSettings<PublisherStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/pubsub").build();
    private final UnaryCallSettings<Topic, Topic> createTopicSettings;
    private final UnaryCallSettings<UpdateTopicRequest, Topic> updateTopicSettings;
    private final BatchingCallSettings<PublishRequest, PublishResponse> publishSettings;
    private final UnaryCallSettings<GetTopicRequest, Topic> getTopicSettings;
    private final PagedCallSettings<ListTopicsRequest, ListTopicsResponse, TopicAdminClient.ListTopicsPagedResponse> listTopicsSettings;
    private final PagedCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, TopicAdminClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings;
    private final PagedCallSettings<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse, TopicAdminClient.ListTopicSnapshotsPagedResponse> listTopicSnapshotsSettings;
    private final UnaryCallSettings<DeleteTopicRequest, Empty> deleteTopicSettings;
    private final UnaryCallSettings<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListTopicsRequest, ListTopicsResponse, Topic> LIST_TOPICS_PAGE_STR_DESC = new PagedListDescriptor<ListTopicsRequest, ListTopicsResponse, Topic>(){

        public String emptyToken() {
            return "";
        }

        public ListTopicsRequest injectToken(ListTopicsRequest payload, String token) {
            return ListTopicsRequest.newBuilder((ListTopicsRequest)payload).setPageToken(token).build();
        }

        public ListTopicsRequest injectPageSize(ListTopicsRequest payload, int pageSize) {
            return ListTopicsRequest.newBuilder((ListTopicsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTopicsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTopicsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Topic> extractResources(ListTopicsResponse payload) {
            return payload.getTopicsList() == null ? ImmutableList.of() : payload.getTopicsList();
        }
    };
    private static final PagedListDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public ListTopicSubscriptionsRequest injectToken(ListTopicSubscriptionsRequest payload, String token) {
            return ListTopicSubscriptionsRequest.newBuilder((ListTopicSubscriptionsRequest)payload).setPageToken(token).build();
        }

        public ListTopicSubscriptionsRequest injectPageSize(ListTopicSubscriptionsRequest payload, int pageSize) {
            return ListTopicSubscriptionsRequest.newBuilder((ListTopicSubscriptionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTopicSubscriptionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTopicSubscriptionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(ListTopicSubscriptionsResponse payload) {
            return payload.getSubscriptionsList() == null ? ImmutableList.of() : payload.getSubscriptionsList();
        }
    };
    private static final PagedListDescriptor<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse, String> LIST_TOPIC_SNAPSHOTS_PAGE_STR_DESC = new PagedListDescriptor<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public ListTopicSnapshotsRequest injectToken(ListTopicSnapshotsRequest payload, String token) {
            return ListTopicSnapshotsRequest.newBuilder((ListTopicSnapshotsRequest)payload).setPageToken(token).build();
        }

        public ListTopicSnapshotsRequest injectPageSize(ListTopicSnapshotsRequest payload, int pageSize) {
            return ListTopicSnapshotsRequest.newBuilder((ListTopicSnapshotsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTopicSnapshotsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTopicSnapshotsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(ListTopicSnapshotsResponse payload) {
            return payload.getSnapshotsList() == null ? ImmutableList.of() : payload.getSnapshotsList();
        }
    };
    private static final PagedListResponseFactory<ListTopicsRequest, ListTopicsResponse, TopicAdminClient.ListTopicsPagedResponse> LIST_TOPICS_PAGE_STR_FACT = new PagedListResponseFactory<ListTopicsRequest, ListTopicsResponse, TopicAdminClient.ListTopicsPagedResponse>(){

        public ApiFuture<TopicAdminClient.ListTopicsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTopicsRequest, ListTopicsResponse> callable, ListTopicsRequest request, ApiCallContext context, ApiFuture<ListTopicsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TOPICS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TopicAdminClient.ListTopicsPagedResponse.createAsync((PageContext<ListTopicsRequest, ListTopicsResponse, Topic>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, TopicAdminClient.ListTopicSubscriptionsPagedResponse> LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, TopicAdminClient.ListTopicSubscriptionsPagedResponse>(){

        public ApiFuture<TopicAdminClient.ListTopicSubscriptionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> callable, ListTopicSubscriptionsRequest request, ApiCallContext context, ApiFuture<ListTopicSubscriptionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TopicAdminClient.ListTopicSubscriptionsPagedResponse.createAsync((PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse, TopicAdminClient.ListTopicSnapshotsPagedResponse> LIST_TOPIC_SNAPSHOTS_PAGE_STR_FACT = new PagedListResponseFactory<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse, TopicAdminClient.ListTopicSnapshotsPagedResponse>(){

        public ApiFuture<TopicAdminClient.ListTopicSnapshotsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> callable, ListTopicSnapshotsRequest request, ApiCallContext context, ApiFuture<ListTopicSnapshotsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TOPIC_SNAPSHOTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TopicAdminClient.ListTopicSnapshotsPagedResponse.createAsync((PageContext<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse, String>)pageContext, futureResponse);
        }
    };
    private static final BatchingDescriptor<PublishRequest, PublishResponse> PUBLISH_BATCHING_DESC = new BatchingDescriptor<PublishRequest, PublishResponse>(){

        public PartitionKey getBatchPartitionKey(PublishRequest request) {
            return new PartitionKey(new Object[]{request.getTopic()});
        }

        public RequestBuilder<PublishRequest> getRequestBuilder() {
            return new RequestBuilder<PublishRequest>(){
                private PublishRequest.Builder builder;

                public void appendRequest(PublishRequest request) {
                    if (this.builder == null) {
                        this.builder = request.toBuilder();
                    } else {
                        this.builder.addAllMessages((Iterable)request.getMessagesList());
                    }
                }

                public PublishRequest build() {
                    return this.builder.build();
                }
            };
        }

        public void splitResponse(PublishResponse batchResponse, Collection<? extends BatchedRequestIssuer<PublishResponse>> batch) {
            int batchMessageIndex = 0;
            for (BatchedRequestIssuer<PublishResponse> batchedRequestIssuer : batch) {
                ArrayList<String> subresponseElements = new ArrayList<String>();
                long subresponseCount = batchedRequestIssuer.getMessageCount();
                int i = 0;
                while ((long)i < subresponseCount) {
                    subresponseElements.add(batchResponse.getMessageIds(batchMessageIndex++));
                    ++i;
                }
                PublishResponse response = PublishResponse.newBuilder().addAllMessageIds(subresponseElements).build();
                batchedRequestIssuer.setResponse((Object)response);
            }
        }

        public void splitException(Throwable throwable, Collection<? extends BatchedRequestIssuer<PublishResponse>> batch) {
            for (BatchedRequestIssuer<PublishResponse> batchedRequestIssuer : batch) {
                batchedRequestIssuer.setException(throwable);
            }
        }

        public long countElements(PublishRequest request) {
            return request.getMessagesCount();
        }

        public long countBytes(PublishRequest request) {
            return request.getSerializedSize();
        }
    };

    public UnaryCallSettings<Topic, Topic> createTopicSettings() {
        return this.createTopicSettings;
    }

    public UnaryCallSettings<UpdateTopicRequest, Topic> updateTopicSettings() {
        return this.updateTopicSettings;
    }

    public BatchingCallSettings<PublishRequest, PublishResponse> publishSettings() {
        return this.publishSettings;
    }

    public UnaryCallSettings<GetTopicRequest, Topic> getTopicSettings() {
        return this.getTopicSettings;
    }

    public PagedCallSettings<ListTopicsRequest, ListTopicsResponse, TopicAdminClient.ListTopicsPagedResponse> listTopicsSettings() {
        return this.listTopicsSettings;
    }

    public PagedCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, TopicAdminClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings() {
        return this.listTopicSubscriptionsSettings;
    }

    public PagedCallSettings<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse, TopicAdminClient.ListTopicSnapshotsPagedResponse> listTopicSnapshotsSettings() {
        return this.listTopicSnapshotsSettings;
    }

    public UnaryCallSettings<DeleteTopicRequest, Empty> deleteTopicSettings() {
        return this.deleteTopicSettings;
    }

    public UnaryCallSettings<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionSettings() {
        return this.detachSubscriptionSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public PublisherStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPublisherStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPublisherStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "pubsub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "pubsub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PublisherStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PublisherStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PublisherStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PublisherStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PublisherStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createTopicSettings = settingsBuilder.createTopicSettings().build();
        this.updateTopicSettings = settingsBuilder.updateTopicSettings().build();
        this.publishSettings = settingsBuilder.publishSettings().build();
        this.getTopicSettings = settingsBuilder.getTopicSettings().build();
        this.listTopicsSettings = settingsBuilder.listTopicsSettings().build();
        this.listTopicSubscriptionsSettings = settingsBuilder.listTopicSubscriptionsSettings().build();
        this.listTopicSnapshotsSettings = settingsBuilder.listTopicSnapshotsSettings().build();
        this.deleteTopicSettings = settingsBuilder.deleteTopicSettings().build();
        this.detachSubscriptionSettings = settingsBuilder.detachSubscriptionSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PublisherStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<Topic, Topic> createTopicSettings;
        private final UnaryCallSettings.Builder<UpdateTopicRequest, Topic> updateTopicSettings;
        private final BatchingCallSettings.Builder<PublishRequest, PublishResponse> publishSettings;
        private final UnaryCallSettings.Builder<GetTopicRequest, Topic> getTopicSettings;
        private final PagedCallSettings.Builder<ListTopicsRequest, ListTopicsResponse, TopicAdminClient.ListTopicsPagedResponse> listTopicsSettings;
        private final PagedCallSettings.Builder<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, TopicAdminClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings;
        private final PagedCallSettings.Builder<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse, TopicAdminClient.ListTopicSnapshotsPagedResponse> listTopicSnapshotsSettings;
        private final UnaryCallSettings.Builder<DeleteTopicRequest, Empty> deleteTopicSettings;
        private final UnaryCallSettings.Builder<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.publishSettings = BatchingCallSettings.newBuilder((BatchingDescriptor)PUBLISH_BATCHING_DESC).setBatchingSettings(BatchingSettings.newBuilder().build());
            this.getTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTopicsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TOPICS_PAGE_STR_FACT);
            this.listTopicSubscriptionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_FACT);
            this.listTopicSnapshotsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TOPIC_SNAPSHOTS_PAGE_STR_FACT);
            this.deleteTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detachSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTopicSettings, this.updateTopicSettings, this.publishSettings, this.getTopicSettings, this.listTopicsSettings, this.listTopicSubscriptionsSettings, this.listTopicSnapshotsSettings, this.deleteTopicSettings, this.detachSubscriptionSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(PublisherStubSettings settings) {
            super((StubSettings)settings);
            this.createTopicSettings = settings.createTopicSettings.toBuilder();
            this.updateTopicSettings = settings.updateTopicSettings.toBuilder();
            this.publishSettings = settings.publishSettings.toBuilder();
            this.getTopicSettings = settings.getTopicSettings.toBuilder();
            this.listTopicsSettings = settings.listTopicsSettings.toBuilder();
            this.listTopicSubscriptionsSettings = settings.listTopicSubscriptionsSettings.toBuilder();
            this.listTopicSnapshotsSettings = settings.listTopicSnapshotsSettings.toBuilder();
            this.deleteTopicSettings = settings.deleteTopicSettings.toBuilder();
            this.detachSubscriptionSettings = settings.detachSubscriptionSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTopicSettings, this.updateTopicSettings, this.publishSettings, this.getTopicSettings, this.listTopicsSettings, this.listTopicSubscriptionsSettings, this.listTopicSnapshotsSettings, this.deleteTopicSettings, this.detachSubscriptionSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PublisherStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PublisherStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PublisherStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(PublisherStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(PublisherStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PublisherStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PublisherStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PublisherStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(PublisherStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(PublisherStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.publishSettings().setBatchingSettings(BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(100L)).setRequestByteThreshold(Long.valueOf(0x100000L)).setDelayThreshold(Duration.ofMillis((long)10L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build()).build());
            builder.publishSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listTopicsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listTopicSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listTopicSnapshotsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.deleteTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.detachSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<Topic, Topic> createTopicSettings() {
            return this.createTopicSettings;
        }

        public UnaryCallSettings.Builder<UpdateTopicRequest, Topic> updateTopicSettings() {
            return this.updateTopicSettings;
        }

        public BatchingCallSettings.Builder<PublishRequest, PublishResponse> publishSettings() {
            return this.publishSettings;
        }

        public UnaryCallSettings.Builder<GetTopicRequest, Topic> getTopicSettings() {
            return this.getTopicSettings;
        }

        public PagedCallSettings.Builder<ListTopicsRequest, ListTopicsResponse, TopicAdminClient.ListTopicsPagedResponse> listTopicsSettings() {
            return this.listTopicsSettings;
        }

        public PagedCallSettings.Builder<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, TopicAdminClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings() {
            return this.listTopicSubscriptionsSettings;
        }

        public PagedCallSettings.Builder<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse, TopicAdminClient.ListTopicSnapshotsPagedResponse> listTopicSnapshotsSettings() {
            return this.listTopicSnapshotsSettings;
        }

        public UnaryCallSettings.Builder<DeleteTopicRequest, Empty> deleteTopicSettings() {
            return this.deleteTopicSettings;
        }

        public UnaryCallSettings.Builder<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionSettings() {
            return this.detachSubscriptionSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public PublisherStubSettings build() throws IOException {
            return new PublisherStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.CANCELLED, StatusCode.Code.INTERNAL, StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNKNOWN, StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNKNOWN, StatusCode.Code.ABORTED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(4.0).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

