/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.RestoreInfo;
import com.google.cloud.spanner.encryption.CustomerManagedEncryption;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public class DatabaseInfo {
    private final DatabaseId id;
    private final State state;
    private final Timestamp createTime;
    private final RestoreInfo restoreInfo;
    private final String versionRetentionPeriod;
    private final Timestamp earliestVersionTime;
    private final CustomerManagedEncryption encryptionConfig;
    private final String defaultLeader;
    private final Dialect dialect;
    private final com.google.spanner.admin.database.v1.Database proto;

    public DatabaseInfo(DatabaseId id, State state) {
        this.id = id;
        this.state = state;
        this.createTime = null;
        this.restoreInfo = null;
        this.versionRetentionPeriod = null;
        this.earliestVersionTime = null;
        this.encryptionConfig = null;
        this.defaultLeader = null;
        this.dialect = null;
        this.proto = null;
    }

    DatabaseInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.state = builder.state;
        this.createTime = builder.createTime;
        this.restoreInfo = builder.restoreInfo;
        this.versionRetentionPeriod = builder.versionRetentionPeriod;
        this.earliestVersionTime = builder.earliestVersionTime;
        this.encryptionConfig = builder.encryptionConfig;
        this.defaultLeader = builder.defaultLeader;
        this.dialect = builder.dialect;
        this.proto = builder.proto;
    }

    public DatabaseId getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public String getVersionRetentionPeriod() {
        return this.versionRetentionPeriod;
    }

    public Timestamp getEarliestVersionTime() {
        return this.earliestVersionTime;
    }

    @Nullable
    public RestoreInfo getRestoreInfo() {
        return this.restoreInfo;
    }

    @Nullable
    public CustomerManagedEncryption getEncryptionConfig() {
        return this.encryptionConfig;
    }

    @Nullable
    public String getDefaultLeader() {
        return this.defaultLeader;
    }

    @Nullable
    public Dialect getDialect() {
        return this.dialect;
    }

    @Nullable
    public com.google.spanner.admin.database.v1.Database getProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseInfo that = (DatabaseInfo)o;
        return this.id.equals(that.id) && this.state == that.state && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.restoreInfo, that.restoreInfo) && Objects.equals(this.versionRetentionPeriod, that.versionRetentionPeriod) && Objects.equals(this.earliestVersionTime, that.earliestVersionTime) && Objects.equals(this.encryptionConfig, that.encryptionConfig) && Objects.equals(this.defaultLeader, that.defaultLeader) && Objects.equals((Object)this.dialect, (Object)that.dialect);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.createTime, this.restoreInfo, this.versionRetentionPeriod, this.earliestVersionTime, this.encryptionConfig, this.defaultLeader, this.dialect});
    }

    public String toString() {
        return String.format("Database[%s, %s, %s, %s, %s, %s, %s, %s, %s]", new Object[]{this.id.getName(), this.state, this.createTime, this.restoreInfo, this.versionRetentionPeriod, this.earliestVersionTime, this.encryptionConfig, this.defaultLeader, this.dialect});
    }

    public static enum State {
        UNSPECIFIED,
        CREATING,
        READY,
        READY_OPTIMIZING;

    }

    static abstract class BuilderImpl
    extends Builder {
        protected final DatabaseId id;
        private State state = State.UNSPECIFIED;
        private Timestamp createTime;
        private RestoreInfo restoreInfo;
        private String versionRetentionPeriod;
        private Timestamp earliestVersionTime;
        private CustomerManagedEncryption encryptionConfig;
        private String defaultLeader;
        private Dialect dialect = Dialect.GOOGLE_STANDARD_SQL;
        private com.google.spanner.admin.database.v1.Database proto;

        BuilderImpl(DatabaseId id) {
            this.id = (DatabaseId)Preconditions.checkNotNull((Object)id);
        }

        BuilderImpl(DatabaseInfo other) {
            this.id = other.id;
            this.state = other.state;
            this.createTime = other.createTime;
            this.restoreInfo = other.restoreInfo;
            this.versionRetentionPeriod = other.versionRetentionPeriod;
            this.earliestVersionTime = other.earliestVersionTime;
            this.encryptionConfig = other.encryptionConfig;
            this.defaultLeader = other.defaultLeader;
            this.dialect = other.dialect;
            this.proto = other.proto;
        }

        @Override
        Builder setState(State state) {
            this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state)));
            return this;
        }

        @Override
        Builder setCreateTime(Timestamp createTime) {
            this.createTime = (Timestamp)Preconditions.checkNotNull((Object)createTime);
            return this;
        }

        @Override
        Builder setRestoreInfo(@Nullable RestoreInfo restoreInfo) {
            this.restoreInfo = restoreInfo;
            return this;
        }

        @Override
        Builder setVersionRetentionPeriod(String versionRetentionPeriod) {
            this.versionRetentionPeriod = versionRetentionPeriod;
            return this;
        }

        @Override
        Builder setEarliestVersionTime(Timestamp earliestVersionTime) {
            this.earliestVersionTime = earliestVersionTime;
            return this;
        }

        @Override
        public Builder setEncryptionConfig(@Nullable CustomerManagedEncryption encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        @Override
        public Builder setDefaultLeader(String defaultLeader) {
            this.defaultLeader = defaultLeader;
            return this;
        }

        @Override
        public Builder setDialect(Dialect dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        Builder setProto(@Nullable com.google.spanner.admin.database.v1.Database proto) {
            this.proto = proto;
            return this;
        }
    }

    public static abstract class Builder {
        abstract Builder setState(State var1);

        abstract Builder setCreateTime(Timestamp var1);

        abstract Builder setRestoreInfo(RestoreInfo var1);

        abstract Builder setVersionRetentionPeriod(String var1);

        abstract Builder setEarliestVersionTime(Timestamp var1);

        public abstract Builder setEncryptionConfig(CustomerManagedEncryption var1);

        public Builder setDefaultLeader(String defaultLeader) {
            throw new UnsupportedOperationException("Unimplemented");
        }

        public Builder setDialect(Dialect dialect) {
            throw new UnsupportedOperationException("Unimplemented");
        }

        abstract Builder setProto(com.google.spanner.admin.database.v1.Database var1);

        public abstract Database build();
    }
}

