/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.trace.v2.stub.GrpcTraceServiceCallableFactory;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.cloud.trace.v2.stub.TraceServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.cloudtrace.v2.BatchWriteSpansRequest;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcTraceServiceStub
extends TraceServiceStub {
    private static final MethodDescriptor<BatchWriteSpansRequest, Empty> batchWriteSpansMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudtrace.v2.TraceService/BatchWriteSpans").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchWriteSpansRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<Span, Span> createSpanMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudtrace.v2.TraceService/CreateSpan").setRequestMarshaller(ProtoUtils.marshaller((Message)Span.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Span.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<BatchWriteSpansRequest, Empty> batchWriteSpansCallable;
    private final UnaryCallable<Span, Span> createSpanCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTraceServiceStub create(TraceServiceStubSettings settings) throws IOException {
        return new GrpcTraceServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTraceServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcTraceServiceStub(TraceServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTraceServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTraceServiceStub(TraceServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTraceServiceStub(TraceServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTraceServiceCallableFactory());
    }

    protected GrpcTraceServiceStub(TraceServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings batchWriteSpansTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchWriteSpansMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<BatchWriteSpansRequest>(){

            public Map<String, String> extract(BatchWriteSpansRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createSpanTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSpanMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Span>(){

            public Map<String, String> extract(Span request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.batchWriteSpansCallable = callableFactory.createUnaryCallable(batchWriteSpansTransportSettings, settings.batchWriteSpansSettings(), clientContext);
        this.createSpanCallable = callableFactory.createUnaryCallable(createSpanTransportSettings, settings.createSpanSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<BatchWriteSpansRequest, Empty> batchWriteSpansCallable() {
        return this.batchWriteSpansCallable;
    }

    @Override
    public UnaryCallable<Span, Span> createSpanCallable() {
        return this.createSpanCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

