/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import com.google.code.maven_replacer_plugin.Replacement;
import com.google.code.maven_replacer_plugin.Replacer;
import com.google.code.maven_replacer_plugin.ReplacerFactory;
import com.google.code.maven_replacer_plugin.file.FileUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplacementProcessor {
    private final FileUtils fileUtils;
    private final ReplacerFactory replacerFactory;

    public ReplacementProcessor(FileUtils fileUtils, ReplacerFactory replacerFactory) {
        this.fileUtils = fileUtils;
        this.replacerFactory = replacerFactory;
    }

    public void replace(List<Replacement> replacements, boolean regex, String file, String outputFile, int regexFlags) throws IOException {
        String content = this.fileUtils.readFile(file);
        for (Replacement replacement : replacements) {
            content = this.replaceContent(regex, regexFlags, content, replacement);
        }
        this.fileUtils.writeToFile(outputFile, content);
    }

    private String replaceContent(boolean regex, int regexFlags, String content, Replacement replacement) {
        if (StringUtils.isEmpty((String)replacement.getToken())) {
            throw new IllegalArgumentException("Token or token file required");
        }
        Replacer replacer = this.replacerFactory.create(replacement);
        return replacer.replace(content, replacement, regex, regexFlags);
    }
}

