/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.aspectj.lang.SoftException;
import protoj.lang.ArchiveFeature;
import protoj.lang.ProjectLayout;
import protoj.lang.internal.InformationException;
import protoj.util.ArgRunnable;
import protoj.util.AssembleTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArchiveEntry<T> {
    private String manifest;
    private String includes;
    private String excludes;
    private ArgRunnable<T> config;
    private File artifact;
    private List<String> mergeArchives;
    private ArchiveFeature parent;
    private String name;

    public ArchiveEntry(String name, ArchiveFeature parent, String fileName, String manifest, String includes, String excludes) {
        try {
            this.name = name;
            this.parent = parent;
            this.mergeArchives = Collections.emptyList();
            this.artifact = new File(parent.getProject().getLayout().getArchiveDir(), fileName);
            this.manifest = manifest;
            this.includes = includes;
            this.excludes = excludes;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initConfig(ArgRunnable<T> config) {
        try {
            this.config = config;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initMergeArchives(String ... archives) {
        try {
            this.mergeArchives = archives == null ? Collections.emptyList() : Arrays.asList(archives);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initMergeArchives(FilenameFilter filter) {
        try {
            File libDir = this.parent.getProject().getLayout().getLibDir();
            String[] archives = libDir.list(filter);
            this.initMergeArchives(archives);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public AssembleTask createAssembleTask(File assembleDir) {
        try {
            ProjectLayout layout = this.parent.getProject().getLayout();
            layout.getArchiveDir().mkdirs();
            File manifestFile = this.getManifest() == null ? null : layout.getManifest(this.getManifest());
            AssembleTask assembleTask = new AssembleTask(this.getArtifact(), assembleDir, manifestFile, this.getIncludes(), this.getExcludes());
            assembleTask.initLogging();
            List<String> mergeArchives = this.getMergeArchives();
            for (String archive : mergeArchives) {
                File file = new File(layout.getLibDir(), archive);
                if (!file.exists()) {
                    StringBuilder message = new StringBuilder();
                    message.append("merge failed: can't find file ");
                    message.append(file.getAbsolutePath());
                    message.append("\nwhile creating archive ");
                    message.append(this.getArtifact().getName());
                    throw new InformationException(message.toString());
                }
                ZipFileSet archiveSet = new ZipFileSet();
                archiveSet.setSrc(file);
                assembleTask.getJar().addFileset((FileSet)archiveSet);
            }
            return assembleTask;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getArtifact() {
        try {
            return this.artifact;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getName() {
        try {
            return this.name;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArgRunnable<T> getConfig() {
        try {
            return this.config;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getExcludes() {
        try {
            return this.excludes;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getIncludes() {
        try {
            return this.includes;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getManifest() {
        try {
            return this.manifest;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArchiveFeature getParent() {
        try {
            return this.parent;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public List<String> getMergeArchives() {
        try {
            return this.mergeArchives;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

