/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.launch.AntMain;
import org.aspectj.lang.SoftException;
import protoj.lang.ClassesArchive;
import protoj.lang.JavadocArchive;
import protoj.lang.ProjectArchive;
import protoj.lang.ProjectLayout;
import protoj.lang.SourceArchive;
import protoj.lang.StandardProject;
import protoj.lang.internal.ProtoExceptionHandler;
import protoj.util.ArgRunnable;
import protoj.util.UntarTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArchiveFeature {
    private static final String PROJECT_DIST_ARCHIVE = "project-dist";
    private ClassesArchive classesArchive;
    private SourceArchive sourceArchive;
    private JavadocArchive javadocArchive;
    private ProjectArchive projectArchive;
    private final StandardProject project;
    private ProjectLayout layout;
    private String extractingArchiveName;

    public ArchiveFeature(StandardProject parent) {
        try {
            this.project = parent;
            this.layout = parent.getLayout();
            this.classesArchive = new ClassesArchive(this);
            this.sourceArchive = new SourceArchive(this);
            this.javadocArchive = new JavadocArchive(this);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initProjectArchive(String name, String prefix, String userName, String group) {
        try {
            this.projectArchive = new ProjectArchive(this, name, prefix, userName, group);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initProjectArchive(String name, String prefix) {
        try {
            this.initProjectArchive(name, prefix, null, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initSelfExtractingArchive(String extractingArchiveName, String jarManifest, String tarPrefix, String tarUserName, String tarGroup) {
        try {
            this.extractingArchiveName = extractingArchiveName;
            this.initProjectArchive(PROJECT_DIST_ARCHIVE, tarPrefix, tarUserName, tarGroup);
            this.getClassesArchive().addEntry(extractingArchiveName, jarManifest, null, "**/*");
            this.getClassesArchive().getEntry(extractingArchiveName).initConfig(new ArgRunnable<ClassesArchive>(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                @Override
                public void run(ClassesArchive archive) {
                    try {
                        archive.initExecutableJar(ArchiveFeature.class.getName());
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            this.getClassesArchive().initIncludeArchives(extractingArchiveName, this.getPath(Task.class).getName(), this.getPath(AntMain.class).getName(), this.getPath(Logger.class).getName(), this.getPath(IOUtils.class).getName(), this.getPath(StandardProject.class).getName(), this.getPath(SoftException.class).getName());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private File getPath(Class<?> name) {
        try {
            File jar = new File(name.getProtectionDomain().getCodeSource().getLocation().toURI());
            return jar;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createSelfExtractingArchive(boolean noSrc, boolean noClasses, boolean isGlobalRwx) {
        try {
            File srcFile = this.getProjectArchive().getArchiveFile();
            File destFile = new File(this.getLayout().getClassesDir(), srcFile.getName());
            destFile.delete();
            this.classesArchive.visit(new ArgRunnable<ClassesArchive.ClassesEntry>(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                @Override
                public void run(ClassesArchive.ClassesEntry entry) {
                    try {
                        if (entry.isClasspathLib()) {
                            String name = entry.getArchiveEntry().getName();
                            ArchiveFeature.access$0(ArchiveFeature.this).createArchive(name);
                        }
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            this.getProjectArchive().createArchive(noSrc, noClasses, isGlobalRwx);
            FileUtils.copyFile((File)srcFile, (File)destFile);
            this.getClassesArchive().createArchive(this.extractingArchiveName);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void clean() {
        try {
            FileUtils.deleteDirectory((File)this.getLayout().getTargetDir());
            FileUtils.deleteDirectory((File)this.getLayout().getClassesDir());
            this.getClassesArchive().visit(new ArgRunnable<ClassesArchive.ClassesEntry>(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                @Override
                public void run(ClassesArchive.ClassesEntry entry) {
                    try {
                        if (entry.isClasspathLib()) {
                            String name = entry.getArchiveEntry().getName();
                            File file = new File(ArchiveFeature.this.getLayout().getLibDir(), name);
                            FileUtils.deleteDirectory((File)file);
                        }
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void addClasses(String name) {
        try {
            this.getClassesArchive().addEntry(name, null, null, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void addJavadoc(String name, String memory) {
        try {
            this.getJavadocArchive().addEntry(name, null, null, null, memory);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void addSources(String name) {
        try {
            this.getSourceArchive().addEntry(name, null, null, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isClassesJar(String name) {
        try {
            return name.endsWith(".jar") && !this.isSourcesJar(name) && !this.isJavadocJar(name);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isJavadocJar(String name) {
        try {
            return name.endsWith(".jar") && name.contains(this.layout.getJavadocPostfix());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isSourcesJar(String name) {
        try {
            return name.endsWith(".jar") && (name.contains(this.layout.getSourcePostfix()) || name.contains(this.layout.getSrcPostfix()));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ClassesArchive getClassesArchive() {
        try {
            return this.classesArchive;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public SourceArchive getSourceArchive() {
        try {
            return this.sourceArchive;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public JavadocArchive getJavadocArchive() {
        try {
            return this.javadocArchive;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ProjectArchive getProjectArchive() {
        try {
            return this.projectArchive;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject getProject() {
        try {
            return this.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ProjectLayout getLayout() {
        try {
            return this.layout;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = stringArray;
        try {
            ProtoExceptionHandler.aspectOf().ajc$before$protoj_lang_internal_UncaughtExceptionPolicy$1$eb752c96(stringArray2);
            File container = new File(ArchiveFeature.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (container == null) {
                throw new RuntimeException("this use-case isn't being invoked from the executable jar");
            }
            JarFile jarFile = new JarFile(container);
            String artifactName = "project-dist.tar.gz";
            File artifactFile = new File(".", artifactName);
            ZipEntry artifactEntry = jarFile.getEntry(artifactName);
            InputStream source = jarFile.getInputStream(artifactEntry);
            try {
                FileOutputStream dest = new FileOutputStream(artifactFile);
                try {
                    IOUtils.copy((InputStream)source, (OutputStream)dest);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)dest);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)source);
            }
            UntarTask untarTask = new UntarTask(artifactFile, new File("."));
            untarTask.initCompression("gzip");
            untarTask.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ ClassesArchive access$0(ArchiveFeature arg0) {
        try {
            return arg0.classesArchive;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

