/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.aspectj.lang.SoftException;
import protoj.lang.ArchiveEntry;
import protoj.lang.ArchiveFeature;
import protoj.lang.ProjectLayout;
import protoj.util.ArgRunnable;
import protoj.util.AssembleTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassesArchive {
    private final ArchiveFeature parent;
    private TreeMap<String, ClassesEntry> entries;
    private AssembleTask currentAssembleTask;
    private ArchiveEntry<ClassesArchive> currentEntry;

    public ClassesArchive(ArchiveFeature parent) {
        try {
            this.entries = new TreeMap();
            this.parent = parent;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void addEntry(String name, String manifest, String includes, String excludes) {
        try {
            String fileName = String.valueOf(name) + ".jar";
            ClassesEntry entry = new ClassesEntry(this.parent, name, fileName, manifest, includes, excludes);
            this.entries.put(name, entry);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initConfig(String name, ArgRunnable<ClassesArchive> config) {
        try {
            this.getEntry(name).initConfig(config);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initPublish(String name, String pomName, String gpgOptions) {
        try {
            this.getEntry(name).initPublish(pomName, gpgOptions);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initClasspathLib(String name) {
        try {
            this.getEntry(name).initClasspathLib();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initIncludeArchives(String name, String ... archives) {
        try {
            this.getEntry(name).getArchiveEntry().initMergeArchives(archives);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initExcludeArchives(String name, String ... archives) {
        try {
            final List<String> excluded = Arrays.asList(archives);
            FilenameFilter filter = new FilenameFilter(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                public boolean accept(File dir, String name) {
                    try {
                        return !excluded.contains(name) && ClassesArchive.access$0(ClassesArchive.this).isClassesJar(name);
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            };
            this.getEntry(name).getArchiveEntry().initMergeArchives(filter);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createArchives() {
        try {
            Set<String> keys = this.entries.keySet();
            for (String key : keys) {
                this.createArchive(key);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createArchive(String name) {
        try {
            ProjectLayout layout = this.parent.getProject().getLayout();
            this.currentEntry = this.getEntry(name).getArchiveEntry();
            this.currentAssembleTask = this.currentEntry.createAssembleTask(layout.getClassesDir());
            ArgRunnable<ClassesArchive> config = this.currentEntry.getConfig();
            if (config != null) {
                config.run(this);
            }
            this.currentAssembleTask.execute();
            boolean isClasspathLib = this.getEntry(name).isClasspathLib();
            if (isClasspathLib) {
                FileUtils.copyFileToDirectory((File)this.currentEntry.getArtifact(), (File)layout.getLibDir());
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ClassesEntry getEntry(String name) {
        try {
            return this.entries.get(name);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initExecutableJar() {
        try {
            String currentMainClass = this.parent.getProject().getDispatchFeature().getCurrentMainClass();
            this.initExecutableJar(currentMainClass);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initExecutableJar(String mainClass) {
        try {
            StringBuilder classPath = new StringBuilder();
            String[] libFiles = this.parent.getLayout().getLibDir().list();
            List<String> mergeArchives = this.getCurrentEntry().getMergeArchives();
            String[] stringArray = libFiles;
            int n = libFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String libFile = stringArray[n2];
                boolean isClassesJar = this.parent.isClassesJar(libFile);
                boolean isMergeArchive = mergeArchives.contains(libFile);
                if (isClassesJar && !isMergeArchive) {
                    classPath.append(libFile);
                    classPath.append(" ");
                }
                ++n2;
            }
            this.getCurrentAssembleTask().initManifest("Main-Class", mainClass);
            this.getCurrentAssembleTask().initManifest("Class-Path", classPath.toString());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void visit(ArgRunnable<ClassesEntry> visitor) {
        try {
            Collection<ClassesEntry> values = this.entries.values();
            for (ClassesEntry entry : values) {
                visitor.run(entry);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public AssembleTask getCurrentAssembleTask() {
        try {
            return this.currentAssembleTask;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArchiveEntry<ClassesArchive> getCurrentEntry() {
        try {
            return this.currentEntry;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ ArchiveFeature access$0(ClassesArchive arg0) {
        try {
            return arg0.parent;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClassesEntry {
        private ArchiveEntry<ClassesArchive> archiveEntry;
        private String pomResource;
        private String gpgOptions;
        private boolean isClasspathLib;

        public ClassesEntry(ArchiveFeature parent, String name, String fileName, String manifest, String includes, String excludes) {
            try {
                this.archiveEntry = new ArchiveEntry(name, parent, fileName, manifest, includes, excludes);
                this.isClasspathLib = false;
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void initConfig(ArgRunnable<ClassesArchive> config) {
            try {
                this.archiveEntry.initConfig(config);
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void initClasspathLib() {
            try {
                this.isClasspathLib = true;
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void initPublish(String pomResource, String gpgOptions) {
            try {
                this.pomResource = pomResource;
                this.gpgOptions = gpgOptions;
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public String getPomResource() {
            try {
                return this.pomResource;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public String getGpgOptions() {
            try {
                return this.gpgOptions;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public ArchiveEntry<ClassesArchive> getArchiveEntry() {
            try {
                return this.archiveEntry;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public boolean isClasspathLib() {
            try {
                return this.isClasspathLib;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

