/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.aspectj.lang.SoftException;
import protoj.lang.CommandStore;
import protoj.lang.DispatchFeature;
import protoj.lang.Instruction;
import protoj.lang.InstructionChain;
import protoj.lang.ResourceFeature;
import protoj.lang.StandardProject;
import protoj.lang.internal.InformationException;
import protoj.lang.internal.ProjectReporter;
import protoj.lang.internal.UserOverride;
import protoj.util.ArgRunnable;
import protoj.util.JavaTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Command {
    private static final String BODY = "body";
    private ArrayList<String> aliases;
    private Runnable bootstrap;
    private Runnable body;
    private final CommandStore store;
    private OptionParser parser;
    private OptionSet options;
    private String memory;
    private Instruction instruction;
    private boolean bootstrapCurrentVm;
    private ArgRunnable<JavaTask> startVmConfig;
    private String helpResource;
    private String helpString;

    public Command(CommandStore store, String name, String memory, Runnable body) {
        try {
            this.aliases = new ArrayList();
            this.store = store;
            this.memory = memory;
            this.bootstrap = this.createBootstrap();
            this.parser = this.createOptionParser();
            this.body = body;
            this.bootstrapCurrentVm = false;
            this.initAliases(name);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initHelpString(String helpString) {
        try {
            this.helpString = helpString;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initHelpResource(String helpResource) {
        try {
            this.helpResource = helpResource;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private OptionParser createOptionParser() {
        try {
            OptionParser parser = new OptionParser();
            parser.accepts(BODY);
            return parser;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private Runnable createBootstrap() {
        try {
            Runnable bootstrap = new Runnable(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                public void run() {
                    try {
                        Command.access$0(Command.this);
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            };
            return bootstrap;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void startVm() {
        try {
            UserOverride.aspectOf().ajc$before$protoj_lang_internal_UserOverride$6$116839fe(this);
            StandardProject parent = this.store.getParent();
            InstructionChain chain = parent.getInstructionChain();
            String optsWithBody = (String.valueOf(this.instruction.getOpts()) + " -" + BODY).trim();
            DispatchFeature dispatchFeature = parent.getDispatchFeature();
            String mainClass = this.bootstrapCurrentVm ? dispatchFeature.getCurrentMainClass() : dispatchFeature.getMainClass();
            String[] args = chain.createMainArgs(this.getName(), optsWithBody);
            dispatchFeature.startVm(mainClass, args, this.memory, this.getStartVmConfig());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void setStartVmConfig(ArgRunnable<JavaTask> startVmConfig) {
        try {
            this.startVmConfig = startVmConfig;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArgRunnable<JavaTask> getStartVmConfig() {
        try {
            return this.startVmConfig;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initAliases(String ... aliases) {
        try {
            this.aliases.addAll((Collection<String>)Arrays.asList(aliases));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initBootstrapCurrentVm() {
        try {
            this.bootstrapCurrentVm = true;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute(Instruction instruction) {
        try {
            this.instruction = instruction;
            this.options = this.parser.parse(instruction.getOpts().split(" "));
            boolean executeBody = this.options.has(BODY);
            if (executeBody) {
                ProjectReporter reporter = this.store.getParent().getDispatchFeature().getReporter();
                reporter.beginCommand(this.getName());
                this.body.run();
            } else {
                this.bootstrap.run();
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getMemory() {
        try {
            return this.memory;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void setMemory(String memory) {
        try {
            this.memory = memory;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getName() {
        try {
            return this.aliases.get(0);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public List<String> getAliases() {
        try {
            return Collections.unmodifiableList(this.aliases);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getDescription() {
        try {
            String description;
            if (this.helpResource != null) {
                ResourceFeature feature = this.store.getParent().getResourceFeature();
                description = feature.filterResourceToString(this.helpResource);
            } else {
                description = this.helpString != null ? this.helpString : "no description provided";
            }
            return description;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public OptionParser getParser() {
        try {
            return this.parser;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getAliasText() {
        try {
            StringBuilder builder = new StringBuilder();
            String name = this.getName();
            builder.append(name);
            if (this.aliases.size() > 1) {
                builder.append(" (");
                for (String alias : this.aliases) {
                    if (alias.equals(name)) continue;
                    builder.append(alias);
                    builder.append(", ");
                }
                builder.delete(builder.length() - 2, builder.length());
                builder.append(")");
            }
            return builder.toString();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public OptionSet getOptions() {
        try {
            return this.options;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean containsAlias(String alias) {
        try {
            return this.aliases.contains(alias);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getInstructionText() {
        try {
            return this.instruction.getText();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public CommandStore getStore() {
        try {
            return this.store;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getHelpText() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("Name: ");
            builder.append(this.getAliasText());
            builder.append("\n\n");
            builder.append(this.getDescription());
            builder.append("\n");
            return builder.toString();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void throwBadOptionsException(String hint) {
        try {
            boolean isHintSpecified;
            StringBuilder builder = new StringBuilder();
            builder.append("The following command contained unrecognized options (ignore any --body switch):\n\n   \"");
            builder.append(this.getInstructionText());
            boolean bl = isHintSpecified = hint != null && hint.length() != 0;
            if (isHintSpecified) {
                builder.append("\"   - ");
                builder.append(hint);
            }
            builder.append("\n\nPlease review the command help as follows:\n");
            builder.append(this.getHelpText());
            throw new InformationException(builder.toString());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ void access$0(Command arg0) {
        try {
            arg0.startVm();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

