/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.aspectj.lang.SoftException;
import org.aspectj.runtime.internal.AroundClosure;
import protoj.lang.ProjectLayout;
import protoj.lang.StandardProject;
import protoj.lang.StandardProperties;
import protoj.lang.internal.InformationException;
import protoj.lang.internal.UserOverride;
import protoj.util.AntTarget;
import protoj.util.ArgRunnable;
import protoj.util.AspectJCompileTask;
import protoj.util.JavacCompileTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompileFeature {
    private final StandardProject parent;
    private ArgRunnable<CompileFeature> config;
    private AspectJCompileTask ajcCompileTask;
    private boolean aspectCompiler;
    private JavacCompileTask javacCompileTask;

    public CompileFeature(StandardProject parent) {
        try {
            this.parent = parent;
            this.aspectCompiler = false;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initConfig(boolean aspectCompiler, ArgRunnable<CompileFeature> config) {
        try {
            this.aspectCompiler = aspectCompiler;
            this.config = config;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initJavacCrossCompile(String target, String extdirs, String bootclasspath) {
        String string = target;
        String string2 = extdirs;
        String string3 = bootclasspath;
        try {
            CompileFeature.initJavacCrossCompile_aroundBody1$advice(this, string, string2, string3, UserOverride.aspectOf(), this, string, string2, string3, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initAjcCrossCompile(String target, String extdirs, String bootclasspath) {
        String string = target;
        String string2 = extdirs;
        String string3 = bootclasspath;
        try {
            CompileFeature.initAjcCrossCompile_aroundBody3$advice(this, string, string2, string3, UserOverride.aspectOf(), this, string, string2, string3, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initJavacSource(String source) {
        String string = source;
        try {
            CompileFeature.initJavacSource_aroundBody5$advice(this, string, UserOverride.aspectOf(), this, string, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initAjcSource(String source) {
        String string = source;
        try {
            CompileFeature.initAjcSource_aroundBody7$advice(this, string, UserOverride.aspectOf(), this, string, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initAjcMemory(String memory) {
        String string = memory;
        try {
            CompileFeature.initAjcMemory_aroundBody9$advice(this, string, UserOverride.aspectOf(), this, string, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initJavacMemory(String memory) {
        String string = memory;
        try {
            CompileFeature.initJavacMemory_aroundBody11$advice(this, string, UserOverride.aspectOf(), this, string, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArgRunnable<CompileFeature> getConfig() {
        try {
            return this.config;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public AspectJCompileTask getAjcCompileTask() {
        try {
            return this.ajcCompileTask;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public JavacCompileTask getJavacCompileTask() {
        try {
            return this.javacCompileTask;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void compile(String includes, String excludes) {
        try {
            if (this.aspectCompiler) {
                this.compileAjc(includes, excludes);
            } else {
                this.compileJavac(includes, excludes);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void compileAjc(String includes, String excludes) {
        try {
            this.copyResources(null, null);
            this.ajcCompileTask = this.createAjcTask();
            DirSet dirSet = this.ajcCompileTask.getDirSet();
            if (includes != null) {
                dirSet.setIncludes(includes);
            }
            if (excludes != null) {
                dirSet.setExcludes(excludes);
            }
            if (this.config != null) {
                this.config.run(this);
            }
            this.ajcCompileTask.execute();
            if (!this.ajcCompileTask.isSuccess()) {
                throw new InformationException("there was a problem compiling the source code");
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void compileJavac(String includes, String excludes) {
        try {
            this.copyResources(null, null);
            this.javacCompileTask = this.createJavacTask();
            DirSet dirSet = this.javacCompileTask.getDirSet();
            if (includes != null) {
                dirSet.setIncludes(includes);
            }
            if (excludes != null) {
                dirSet.setExcludes(excludes);
            }
            if (this.config != null) {
                this.config.run(this);
            }
            this.javacCompileTask.execute();
            if (!this.javacCompileTask.isSuccess()) {
                throw new InformationException("there was a problem compiling the source code");
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void compileJavac(List<String> options) {
        try {
            File srcDir = this.parent.getLayout().getSrcDir();
            if (srcDir.exists()) {
                this.copyResources(null, "**/aop.xml");
                this.parent.getLogger().info((Object)"applying javac options:");
                JavacCompileTask task = this.createJavacTask();
                this.assignProperties(options, task);
                task.execute();
                if (!task.isSuccess()) {
                    throw new InformationException("there was a problem compiling the source code");
                }
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void compileAjc(List<String> options) {
        try {
            File srcDir = this.parent.getLayout().getSrcDir();
            if (srcDir.exists()) {
                this.copyResources(null, "**/aop.xml");
                this.parent.getLogger().info((Object)"applying ajc options:");
                AspectJCompileTask task = this.createAjcTask();
                this.assignProperties(options, task);
                task.execute();
                if (!task.isSuccess()) {
                    throw new InformationException("there was a problem compiling the source code");
                }
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void assignProperties(List<String> opts, Object task) {
        try {
            for (String opt : opts) {
                String[] property = opt.split("=");
                String name = property[0];
                String value = property[1];
                this.parent.getLogger().info((Object)String.format("%s=%s", name, value));
                PropertyUtils.setProperty((Object)task, (String)name, (Object)value);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isAspectCompiler() {
        try {
            return this.aspectCompiler;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public AspectJCompileTask createAjcTask() {
        try {
            ProjectLayout layout = this.parent.getLayout();
            AspectJCompileTask task = new AspectJCompileTask(layout.getJavaDir(), layout.getClassesDir(), layout.getClasspathConfig());
            task.initLogging();
            task.getCompileTask().setFailonerror(true);
            return task;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public JavacCompileTask createJavacTask() {
        try {
            ProjectLayout layout = this.parent.getLayout();
            JavacCompileTask task = new JavacCompileTask(layout.getJavaDir(), layout.getClassesDir(), this.parent.getLayout().getClasspathConfig());
            task.initLogging();
            return task;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void copyResources(String includes, String excludes) {
        try {
            AntTarget target = new AntTarget("compile-feature-copy");
            ProjectLayout layout = this.parent.getLayout();
            layout.getClassesDir().mkdirs();
            Copy copy = new Copy();
            target.addTask((Task)copy);
            copy.setTaskName("copy");
            copy.setTodir(layout.getClassesDir());
            FileSet resourceFiles = new FileSet();
            resourceFiles.setDir(layout.getResourcesDir());
            if (includes != null) {
                resourceFiles.setIncludes(includes);
            }
            if (excludes != null) {
                resourceFiles.setExcludes(excludes);
            }
            copy.addFileset(resourceFiles);
            target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject getParent() {
        try {
            return this.parent;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private static final /* synthetic */ void initJavacCrossCompile_aroundBody0(CompileFeature this_, String target, String extdirs, String bootclasspath) {
        this_.getJavacCompileTask().initCrossCompile(target, extdirs, bootclasspath);
    }

    private static final /* synthetic */ void initJavacCrossCompile_aroundBody1$advice(CompileFeature this_, String target, String extdirs, String bootclasspath, UserOverride ajc$aspectInstance, CompileFeature feature, String target2, String extdirs2, String bootclasspath2, AroundClosure ajc$aroundClosure) {
        StandardProperties props = feature.getParent().getProperties();
        String userTarget = props.getCompileTarget().getValue();
        String userExtdirs = props.getCompileExtdirs().getValue();
        String userBootclasspath = props.getCompileBootclasspath().getValue();
        String newTarget = userTarget.length() > 0 ? userTarget : target2;
        String newExtdirs = userExtdirs.length() > 0 ? userExtdirs : extdirs2;
        String newBootclasspath = userBootclasspath.length() > 0 ? userBootclasspath : bootclasspath2;
        Logger logger = feature.getParent().getLogger();
        logger.info((Object)("overriding compile target: " + newTarget));
        logger.info((Object)("overriding compile extdirs: " + newExtdirs));
        logger.info((Object)("overriding compile bootclasspath: " + newBootclasspath));
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = newBootclasspath;
        String string2 = newExtdirs;
        String string3 = newTarget;
        CompileFeature compileFeature = feature;
        CompileFeature.initJavacCrossCompile_aroundBody0(compileFeature, string3, string2, string);
    }

    private static final /* synthetic */ void initAjcCrossCompile_aroundBody2(CompileFeature this_, String target, String extdirs, String bootclasspath) {
        this_.getAjcCompileTask().initCrossCompile(target, extdirs, bootclasspath);
    }

    private static final /* synthetic */ void initAjcCrossCompile_aroundBody3$advice(CompileFeature this_, String target, String extdirs, String bootclasspath, UserOverride ajc$aspectInstance, CompileFeature feature, String target2, String extdirs2, String bootclasspath2, AroundClosure ajc$aroundClosure) {
        StandardProperties props = feature.getParent().getProperties();
        String userTarget = props.getCompileTarget().getValue();
        String userExtdirs = props.getCompileExtdirs().getValue();
        String userBootclasspath = props.getCompileBootclasspath().getValue();
        String newTarget = userTarget.length() > 0 ? userTarget : target2;
        String newExtdirs = userExtdirs.length() > 0 ? userExtdirs : extdirs2;
        String newBootclasspath = userBootclasspath.length() > 0 ? userBootclasspath : bootclasspath2;
        Logger logger = feature.getParent().getLogger();
        logger.info((Object)("overriding compile target: " + newTarget));
        logger.info((Object)("overriding compile extdirs: " + newExtdirs));
        logger.info((Object)("overriding compile bootclasspath: " + newBootclasspath));
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = newBootclasspath;
        String string2 = newExtdirs;
        String string3 = newTarget;
        CompileFeature compileFeature = feature;
        CompileFeature.initAjcCrossCompile_aroundBody2(compileFeature, string3, string2, string);
    }

    private static final /* synthetic */ void initJavacSource_aroundBody4(CompileFeature this_, String source) {
        this_.getJavacCompileTask().getCompileTask().setSource(source);
    }

    private static final /* synthetic */ void initJavacSource_aroundBody5$advice(CompileFeature this_, String source, UserOverride ajc$aspectInstance, CompileFeature feature, String source2, AroundClosure ajc$aroundClosure) {
        StandardProperties props = feature.getParent().getProperties();
        String userSource = props.getCompileSource().getValue();
        String newSource = userSource.length() > 0 ? userSource : source2;
        Logger logger = feature.getParent().getLogger();
        logger.info((Object)("overriding compile source: " + newSource));
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = source2;
        CompileFeature compileFeature = feature;
        CompileFeature.initJavacSource_aroundBody4(compileFeature, string);
    }

    private static final /* synthetic */ void initAjcSource_aroundBody6(CompileFeature this_, String source) {
        this_.getAjcCompileTask().getCompileTask().setSource(source);
    }

    private static final /* synthetic */ void initAjcSource_aroundBody7$advice(CompileFeature this_, String source, UserOverride ajc$aspectInstance, CompileFeature feature, String source2, AroundClosure ajc$aroundClosure) {
        StandardProperties props = feature.getParent().getProperties();
        String userSource = props.getCompileSource().getValue();
        String newSource = userSource.length() > 0 ? userSource : source2;
        Logger logger = feature.getParent().getLogger();
        logger.info((Object)("overriding compile source: " + newSource));
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = source2;
        CompileFeature compileFeature = feature;
        CompileFeature.initAjcSource_aroundBody6(compileFeature, string);
    }

    private static final /* synthetic */ void initAjcMemory_aroundBody8(CompileFeature this_, String memory) {
        this_.getAjcCompileTask().getCompileTask().setMaxmem(memory);
    }

    private static final /* synthetic */ void initAjcMemory_aroundBody9$advice(CompileFeature this_, String memory, UserOverride ajc$aspectInstance, CompileFeature feature, String memory2, AroundClosure ajc$aroundClosure) {
        StandardProperties props = feature.getParent().getProperties();
        String userMemory = props.getCompileMemory().getValue();
        String newMemory = userMemory.length() > 0 ? userMemory : memory2;
        Logger logger = feature.getParent().getLogger();
        logger.info((Object)("overriding compile memory: " + newMemory));
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = memory2;
        CompileFeature compileFeature = feature;
        CompileFeature.initAjcMemory_aroundBody8(compileFeature, string);
    }

    private static final /* synthetic */ void initJavacMemory_aroundBody10(CompileFeature this_, String memory) {
        this_.getJavacCompileTask().getCompileTask().setMemoryMaximumSize(memory);
    }

    private static final /* synthetic */ void initJavacMemory_aroundBody11$advice(CompileFeature this_, String memory, UserOverride ajc$aspectInstance, CompileFeature feature, String memory2, AroundClosure ajc$aroundClosure) {
        StandardProperties props = feature.getParent().getProperties();
        String userMemory = props.getCompileMemory().getValue();
        String newMemory = userMemory.length() > 0 ? userMemory : memory2;
        Logger logger = feature.getParent().getLogger();
        logger.info((Object)("overriding compile memory: " + newMemory));
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = memory2;
        CompileFeature compileFeature = feature;
        CompileFeature.initJavacMemory_aroundBody10(compileFeature, string);
    }
}

