/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import org.aspectj.lang.SoftException;

public final class DependencyInfo {
    private String groupId;
    private String artifactId;
    private String version;
    private String jarName;
    private boolean isRepo;

    public DependencyInfo(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, true);
        try {
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo(String artifactId, String jarName) {
        this(null, artifactId, null, jarName, false);
        try {
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo(String groupId, String artifactId, String version, String jarName, boolean isRepo) {
        try {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.jarName = jarName;
            this.isRepo = isRepo;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getGroupId() {
        try {
            return this.groupId;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getArtifactId() {
        try {
            return this.artifactId;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getVersion() {
        try {
            return this.version;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getJarName() {
        try {
            return this.jarName != null ? this.jarName : this.getVersionedJarName();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getVersionedJarName() {
        try {
            return String.valueOf(this.artifactId) + "-" + this.version + ".jar";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getUnversionedJarName() {
        try {
            return String.valueOf(this.artifactId) + ".jar";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isRepo() {
        try {
            return this.isRepo;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void setRepo(boolean isRepo) {
        try {
            this.isRepo = isRepo;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

