/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.aspectj.lang.SoftException;
import protoj.lang.DependencyInfo;
import protoj.lang.StandardProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyStore {
    private HashMap<String, DependencyInfo> dependencies;
    private DependencyInfo beanUtils;
    private DependencyInfo collections;
    private DependencyInfo configuration;
    private DependencyInfo io;
    private DependencyInfo lang;
    private DependencyInfo logging;
    private DependencyInfo junit;
    private DependencyInfo log4j;
    private DependencyInfo jopt;
    private DependencyInfo ant;
    private DependencyInfo antLog4j;
    private DependencyInfo antJunit;
    private DependencyInfo antJsch;
    private DependencyInfo antLauncher;
    private DependencyInfo ivy;
    private DependencyInfo mavenAntTasks;
    private DependencyInfo velocity;
    private DependencyInfo aspectjrt;
    private DependencyInfo aspectjweaver;
    private DependencyInfo aspectjtools;
    private DependencyInfo googlecode;
    private DependencyInfo jsch;
    private DependencyInfo protoj;
    private final StandardProject parent;

    public DependencyStore(StandardProject parent) {
        try {
            this.dependencies = new HashMap();
            this.parent = parent;
            this.beanUtils = this.addRepoDependency("commons-beanutils", "commons-beanutils", "1.8.0");
            this.collections = this.addRepoDependency("commons-collections", "commons-collections", "3.2.1");
            this.configuration = this.addRepoDependency("commons-configuration", "commons-configuration", "1.6");
            this.io = this.addRepoDependency("commons-io", "commons-io", "1.4");
            this.lang = this.addRepoDependency("commons-lang", "commons-lang", "2.4");
            this.logging = this.addRepoDependency("commons-logging", "commons-logging", "1.1.1");
            this.junit = this.addRepoDependency("junit", "junit", "4.5");
            this.log4j = this.addRepoDependency("log4j", "log4j", "1.2.15");
            this.jopt = this.addRepoDependency("net.sf.jopt-simple", "jopt-simple", "3.0");
            this.ant = this.addRepoDependency("org.apache.ant", "ant", "1.7.1");
            this.antLog4j = this.addRepoDependency("org.apache.ant", "ant-apache-log4j", "1.7.1");
            this.antJunit = this.addRepoDependency("org.apache.ant", "ant-junit", "1.7.1");
            this.antJsch = this.addRepoDependency("org.apache.ant", "ant-jsch", "1.7.1");
            this.antLauncher = this.addRepoDependency("org.apache.ant", "ant-launcher", "1.7.1");
            this.ivy = this.addRepoDependency("org.apache.ivy", "ivy", "2.0.0");
            this.mavenAntTasks = this.addRepoDependency("org.apache.maven", "maven-ant-tasks", "2.0.9");
            this.velocity = this.addRepoDependency("org.apache.velocity", "velocity", "1.6.2");
            this.protoj = this.addDependency("com.google.code.protoj", this.getProtojArtifactId(), parent.getProtojVersion(), null, false);
            this.aspectjrt = this.addCustomDependency("aspectjrt", "aspectjrt.jar");
            this.aspectjweaver = this.addCustomDependency("aspectjweaver", "aspectjweaver.jar");
            this.aspectjtools = this.addCustomDependency("aspectjtools", "aspectjtools.jar");
            this.googlecode = this.addCustomDependency("ant-googlecode", "ant-googlecode-0.0.1.jar");
            this.jsch = this.addCustomDependency("jsch", "jsch-0.1.41.jar");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo addRepoDependency(String groupId, String artifactId, String version) {
        try {
            DependencyInfo info = new DependencyInfo(groupId, artifactId, version);
            this.dependencies.put(artifactId, info);
            return info;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo addCustomDependency(String artifactId, String jarName) {
        try {
            DependencyInfo info = new DependencyInfo(artifactId, jarName);
            this.dependencies.put(artifactId, info);
            return info;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo addDependency(String groupId, String artifactId, String version, String jarName, boolean isRepo) {
        try {
            DependencyInfo info = new DependencyInfo(groupId, artifactId, version, jarName, isRepo);
            this.dependencies.put(artifactId, info);
            return info;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo removeDependency(String artifactId) {
        try {
            return this.dependencies.remove(artifactId);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo removeDependency(DependencyInfo info) {
        try {
            return this.removeDependency(info.getArtifactId());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getDependency(String artifactId) {
        try {
            return this.dependencies.get(artifactId);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Collection<DependencyInfo> getRepoDependencies() {
        try {
            ArrayList<DependencyInfo> resultInfos = new ArrayList<DependencyInfo>();
            Collection<DependencyInfo> allInfos = this.dependencies.values();
            for (DependencyInfo info : allInfos) {
                if (!info.isRepo()) continue;
                resultInfos.add(info);
            }
            return resultInfos;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Collection<DependencyInfo> getCustomDependencies() {
        try {
            ArrayList<DependencyInfo> resultInfos = new ArrayList<DependencyInfo>();
            Collection<DependencyInfo> allInfos = this.dependencies.values();
            for (DependencyInfo info : allInfos) {
                if (info.isRepo()) continue;
                resultInfos.add(info);
            }
            return resultInfos;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Collection<DependencyInfo> getDependencies() {
        try {
            return this.dependencies.values();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getBeanUtils() {
        try {
            return this.beanUtils;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getCollections() {
        try {
            return this.collections;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getConfiguration() {
        try {
            return this.configuration;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getIo() {
        try {
            return this.io;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getLang() {
        try {
            return this.lang;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getLogging() {
        try {
            return this.logging;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getJunit() {
        try {
            return this.junit;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getLog4j() {
        try {
            return this.log4j;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getJopt() {
        try {
            return this.jopt;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getAnt() {
        try {
            return this.ant;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getAntLog4j() {
        try {
            return this.antLog4j;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getAntJunit() {
        try {
            return this.antJunit;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getAntJsch() {
        try {
            return this.antJsch;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getAntLauncher() {
        try {
            return this.antLauncher;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getIvy() {
        try {
            return this.ivy;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getMavenAntTasks() {
        try {
            return this.mavenAntTasks;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getVelocity() {
        try {
            return this.velocity;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getAspectjrt() {
        try {
            return this.aspectjrt;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getAspectjweaver() {
        try {
            return this.aspectjweaver;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getAspectjtools() {
        try {
            return this.aspectjtools;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getGooglecode() {
        try {
            return this.googlecode;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getJsch() {
        try {
            return this.jsch;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getProtoj() {
        try {
            return this.protoj;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getProtojArtifactId() {
        try {
            String tag = this.parent.isJdk6() ? "protoj-jdk6" : "protoj-jdk5";
            return tag;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

