/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.aspectj.lang.SoftException;
import org.aspectj.runtime.internal.AroundClosure;
import protoj.lang.ProjectLayout;
import protoj.lang.StandardProject;
import protoj.lang.StandardProperties;
import protoj.lang.internal.UserOverride;
import protoj.util.AntTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DirconfFeature {
    private final StandardProject parent;
    private File workingDir;
    private final File home;

    public DirconfFeature(StandardProject parent) {
        this(parent, parent.getLayout().getConfDir());
        try {
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public DirconfFeature(StandardProject parent, File home) {
        void var2_2;
        void var1_1;
        void var3_3 = var1_1;
        void var4_4 = var2_2;
        try {
            DirconfFeature.init$_aroundBody1$advice(this, (StandardProject)var3_3, (File)var4_4, UserOverride.aspectOf(), this, (StandardProject)var3_3, (File)var4_4, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getWorkingDir() {
        try {
            return this.workingDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void configure(String name, boolean interpolate) {
        try {
            File profileDir = this.getProfileDir(name);
            this.getWorkingDir().mkdir();
            ProjectLayout layout = this.parent.getLayout();
            FileUtils.deleteDirectory((File)this.getWorkingDir());
            if (interpolate) {
                this.reducePropertiesToWorkingDir(profileDir);
            } else {
                this.mergePropertiesToWorkingDir(profileDir);
            }
            this.copyDir(profileDir, this.getWorkingDir(), null, "conf/*.properties", interpolate);
            this.copyDir(this.getWorkingDir(), layout.getRootDir(), null, null, false);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void clean(String name) {
        try {
            File profileDir = this.getProfileDir(name);
            ProjectLayout layout = this.parent.getLayout();
            File projectRootDir = layout.getRootDir();
            ArrayList<File> profileResources = new ArrayList<File>();
            this.listFiles(profileDir, profileResources);
            for (File profileResource : profileResources) {
                String relativePath = this.getRelativePath(profileDir, profileResource);
                File projectResource = new File(projectRootDir, relativePath);
                projectResource.delete();
            }
            layout.getPropertiesFile().delete();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private File getProfileDir(String name) {
        try {
            return new File(this.home, name);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void listFiles(File directory, final List<File> profileResources) {
        try {
            directory.listFiles(new FileFilter(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                public boolean accept(File pathname) {
                    try {
                        if (pathname.isDirectory()) {
                            DirconfFeature.access$0(DirconfFeature.this, pathname, profileResources);
                        } else {
                            profileResources.add(pathname);
                        }
                        return false;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void reducePropertiesToWorkingDir(File profileInstanceDir) {
        try {
            CompositeConfiguration comp = new CompositeConfiguration();
            List<File> profileFiles = this.getConfProperties(profileInstanceDir);
            for (File profileFile : profileFiles) {
                comp.addConfiguration((Configuration)new PropertiesConfiguration(profileFile));
            }
            File propertiesFile = this.parent.getLayout().getPropertiesFile();
            if (propertiesFile.exists()) {
                PropertiesConfiguration conf = new PropertiesConfiguration(propertiesFile);
                comp.addConfiguration((Configuration)conf);
            }
            PropertiesConfiguration workingConfig = new PropertiesConfiguration(this.getWorkingPropertiesFile());
            workingConfig.copy(comp.interpolatedConfiguration());
            workingConfig.save();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private File getWorkingPropertiesFile() {
        try {
            ProjectLayout layout = this.parent.getLayout();
            String workingPropertiesName = layout.getPropertiesFile().getName();
            String confDirName = layout.getConfDir().getName();
            File workingConfDir = new File(this.getWorkingDir(), confDirName);
            File workingPropertiesFile = new File(workingConfDir, workingPropertiesName);
            return workingPropertiesFile;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void mergePropertiesToWorkingDir(File profileInstanceDir) {
        try {
            List<File> profileFiles = this.getConfProperties(profileInstanceDir);
            for (File profileFile : profileFiles) {
                String relativePath = this.getRelativePath(profileInstanceDir, profileFile);
                File projectFile = new File(this.parent.getLayout().getRootDir(), relativePath);
                this.mergeFilesToWorkingDir(profileFile, projectFile);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void mergeFilesToWorkingDir(File profileFile, File projectFile) {
        try {
            File rootDir = this.parent.getLayout().getRootDir();
            String relativePath = this.getRelativePath(rootDir, projectFile);
            if (projectFile.exists()) {
                PropertiesConfiguration profileProps = new PropertiesConfiguration(profileFile);
                PropertiesConfiguration projectProps = new PropertiesConfiguration(projectFile);
                CompositeConfiguration mergedProps = new CompositeConfiguration();
                mergedProps.addConfiguration((Configuration)profileProps);
                mergedProps.addConfiguration((Configuration)projectProps);
                File workingFile = new File(this.getWorkingDir(), relativePath);
                PropertiesConfiguration workingProps = new PropertiesConfiguration(workingFile);
                workingProps.copy((Configuration)mergedProps);
                workingProps.save();
            } else {
                File destFile = new File(this.getWorkingDir(), relativePath);
                AntTarget target = new AntTarget("configure");
                Copy copy = new Copy();
                copy.setTaskName("copy-property-file");
                target.addTask((Task)copy);
                copy.setFile(profileFile);
                copy.setTofile(destFile);
                copy.setOverwrite(false);
                target.execute();
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private List<File> getConfProperties(File parentDir) {
        try {
            final ArrayList<File> confProperties = new ArrayList<File>();
            ProjectLayout layout = this.parent.getLayout();
            File confDir = new File(parentDir, layout.getConfDir().getName());
            confDir.listFiles(new FileFilter(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                public boolean accept(File pathname) {
                    try {
                        boolean isPropertyFile = pathname.getName().endsWith(".properties");
                        if (isPropertyFile) {
                            confProperties.add(pathname);
                        }
                        return false;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            return confProperties;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private String getRelativePath(File parent, File child) {
        try {
            int relativePathPos = parent.getAbsolutePath().length();
            return child.getAbsolutePath().substring(relativePathPos);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void copyDir(File src, File dest, String includes, String excludes, boolean resolveProperties) {
        try {
            AntTarget target = new AntTarget("configure");
            target.initLogging(2);
            Copy copy = new Copy();
            target.addTask((Task)copy);
            copy.setTaskName("copy-dir");
            FileSet fileSet = new FileSet();
            fileSet.setDir(src);
            if (includes != null) {
                fileSet.setIncludes(includes);
            }
            if (excludes != null) {
                fileSet.setExcludes(excludes);
            }
            copy.addFileset(fileSet);
            copy.setTodir(dest);
            copy.setOverwrite(true);
            if (resolveProperties) {
                FilterSet filterSet = copy.createFilterSet();
                filterSet.setBeginToken("${");
                filterSet.setEndToken("}");
                FilterSet.FiltersFile filtersFile = filterSet.createFiltersfile();
                filtersFile.setFile(this.getWorkingPropertiesFile());
            }
            target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ void access$0(DirconfFeature arg0, File arg1, List arg2) {
        try {
            arg0.listFiles(arg1, arg2);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private static final /* synthetic */ void init$_aroundBody0(DirconfFeature this_, StandardProject parent, File home) {
        this_.parent = parent;
        this_.home = home;
        this_.workingDir = new File(parent.getLayout().getTargetDir(), "dirconfig");
    }

    private static final /* synthetic */ void init$_aroundBody1$advice(DirconfFeature this_, StandardProject parent, File home, UserOverride ajc$aspectInstance, DirconfFeature config, StandardProject project, File home2, AroundClosure ajc$aroundClosure) {
        StandardProperties props = project.getProperties();
        String homeOverride = props.getProfileHome().getValue();
        File newHome = homeOverride.length() > 0 ? new File(homeOverride) : home2;
        AroundClosure aroundClosure = ajc$aroundClosure;
        File file = newHome;
        StandardProject standardProject = project;
        DirconfFeature dirconfFeature = config;
        DirconfFeature.init$_aroundBody0(dirconfFeature, standardProject, file);
    }
}

