/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.aspectj.lang.SoftException;
import org.aspectj.runtime.internal.AroundClosure;
import protoj.lang.Command;
import protoj.lang.CommandStore;
import protoj.lang.Instruction;
import protoj.lang.InstructionChain;
import protoj.lang.ProjectLayout;
import protoj.lang.StandardProject;
import protoj.lang.command.JavaCommand;
import protoj.lang.internal.InformationException;
import protoj.lang.internal.ProjectReporter;
import protoj.lang.internal.UserOverride;
import protoj.util.ArgRunnable;
import protoj.util.JavaTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DispatchFeature {
    private static final String SCRIPT_VM_PROPERTY = "protoj.scriptVm";
    private JavaCommand javaCommand;
    private ProjectReporter reporter;
    private String mainClass;
    private String mainMemory;
    private final StandardProject parent;
    private String currentMainClass;
    private boolean scriptVm;
    private boolean statusWindow;
    private ArgRunnable<JavaTask> startVmConfig;
    private long elapsedHours;
    private long elapsedMinutes;
    private long elapsedSeconds;
    private File weaverJar;

    public DispatchFeature(StandardProject parent) {
        try {
            this.parent = parent;
            this.javaCommand = new JavaCommand(this);
            this.reporter = new ProjectReporter(parent);
            this.currentMainClass = null;
            this.currentMainClass = this.createCurrentMainClass();
            this.scriptVm = this.createScriptVm();
            this.statusWindow = false;
            this.initBootstrap(this.getCurrentMainClass(), null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initBootstrap(String mainClass, String mainMemory) {
        String string = mainClass;
        String string2 = mainMemory;
        try {
            DispatchFeature.initBootstrap_aroundBody1$advice(this, string, string2, UserOverride.aspectOf(), this, string2, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initLoadTimeWeaving(String partialName) {
        try {
            final String searchName = partialName == null ? "aspectjweaver.jar" : partialName;
            File libDir = this.parent.getLayout().getLibDir();
            String[] matches = libDir.list(new FilenameFilter(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                public boolean accept(File dir, String name) {
                    try {
                        return name.contains(searchName);
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            if (matches.length == 0) {
                throw new InformationException("load time weaving bad config: couldn't find a jar file whose name contains " + searchName);
            }
            if (matches.length > 1) {
                throw new InformationException("load time weaving bad config: found more than one jar file whose name contains " + searchName);
            }
            this.weaverJar = new File(libDir, matches[0]);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private String createCurrentMainClass() {
        try {
            try {
                throw new RuntimeException();
            }
            catch (Exception e) {
                StackTraceElement[] trace = e.getStackTrace();
                return trace[trace.length - 1].getClassName();
            }
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private boolean createScriptVm() {
        try {
            String scriptVm = System.getProperty(SCRIPT_VM_PROPERTY, Boolean.TRUE.toString());
            return Boolean.valueOf(scriptVm);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ProjectReporter getReporter() {
        try {
            return this.reporter;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public long getElapsedHours() {
        try {
            return this.elapsedHours;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public long getElapsedMinutes() {
        try {
            return this.elapsedMinutes;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public long getElapsedSeconds() {
        try {
            return this.elapsedSeconds;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void dispatchCommands() {
        try {
            try {
                long startTimeMillis = new Date().getTime();
                try {
                    this.parent.getInstructionChain().visitAndRemove(new Dispatcher());
                }
                finally {
                    this.updateElapsedTime(startTimeMillis);
                }
                if (this.isScriptVm()) {
                    this.reporter.projectSucceeded();
                }
                this.exitApplication(0);
            }
            catch (StartVmException e) {
                if (e.getMessage() != null) {
                    System.out.println(e.getMessage());
                }
                this.exitApplication(1);
            }
            catch (InformationException e) {
                this.reporter.projectFailed(e.getMessage());
                this.exitApplication(1);
            }
            catch (Throwable e) {
                this.reporter.projectFailed(e);
                this.exitApplication(1);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void exitApplication(int code) {
        try {
            if (!this.isScriptVm()) {
                System.exit(code);
            } else if (this.isStatusWindow()) {
                this.showStatusWindow(code);
            } else {
                System.exit(code);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void updateElapsedTime(long startTimeMillis) {
        try {
            long endTime = new Date().getTime();
            long elapsedMillis = endTime - startTimeMillis;
            long oneHourInMillis = 3600000L;
            long oneMinuteInMillis = 60000L;
            long oneSecondInMillis = 1000L;
            this.elapsedHours = elapsedMillis / oneHourInMillis;
            float leftoverFromHours = (float)elapsedMillis % (float)oneHourInMillis;
            this.elapsedMinutes = (long)(leftoverFromHours / (float)oneMinuteInMillis);
            float leftoverFromMinutes = leftoverFromHours % (float)oneMinuteInMillis;
            this.elapsedSeconds = (long)(leftoverFromMinutes / (float)oneSecondInMillis);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void showStatusWindow(int code) {
        try {
            JFrame frame = new JFrame();
            frame.setSize(300, 100);
            frame.setResizable(false);
            frame.setDefaultCloseOperation(3);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            String elapsedTime = String.format("%02d:%02d:%02d", this.getElapsedHours(), this.getElapsedMinutes(), this.getElapsedSeconds());
            JLabel label = new JLabel(elapsedTime, 0);
            Font font = label.getFont().deriveFont(200.0f);
            label.setFont(font);
            panel.add(label);
            panel.setBackground(code == 0 ? Color.green : Color.red);
            frame.getContentPane().add(panel);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setSize(screenSize.width, screenSize.height);
            frame.validate();
            frame.setVisible(true);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private boolean isInProjectMain() {
        try {
            return this.getCurrentMainClass().equals(this.getMainClass());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void startProjectMainVm() {
        try {
            UserOverride.aspectOf().ajc$before$protoj_lang_internal_UserOverride$5$ad6819bf(this);
            String[] args = this.parent.getInstructionChain().createArgsAndRemove(false);
            this.startVm(this.mainClass, args, this.mainMemory, this.getStartVmConfig());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public JavaTask startVm(String mainClass, String[] args, String memory, ArgRunnable<JavaTask> config) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("starting vm " + mainClass + ":" + memory);
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                builder.append(" ");
                builder.append(arg);
                ++n2;
            }
            this.parent.getLogger().info((Object)builder);
            ProjectLayout layout = this.parent.getLayout();
            JavaTask vm = new JavaTask();
            vm.setMainClass(mainClass);
            vm.initFork(memory, false);
            vm.initArgs(args);
            vm.initClasspath(layout.getClasspathConfig());
            if (this.weaverJar != null) {
                vm.initWeaving(this.weaverJar);
            }
            vm.initJvmargs("-Dprotoj.scriptVm=false");
            if (config != null) {
                config.run(vm);
            }
            vm.execute();
            vm.writeOutput();
            if (!vm.isSuccess()) {
                String stderr = vm.getStderr();
                String message = stderr != null && stderr.contains("java.lang.NoClassDefFoundError") ? "did you remember to execute the compile command first of all?" : "";
                throw new StartVmException(message);
            }
            return vm;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getCurrentMainClass() {
        try {
            return this.currentMainClass;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getMainClass() {
        try {
            return this.mainClass;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getMainMemory() {
        try {
            return this.mainMemory;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isScriptVm() {
        try {
            return this.scriptVm;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void setStatusWindow(boolean statusWindow) {
        try {
            if (statusWindow && GraphicsEnvironment.isHeadless()) {
                throw new RuntimeException("can't configure a status window in a headless environment");
            }
            this.statusWindow = statusWindow;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isStatusWindow() {
        try {
            return this.statusWindow;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void setStartVmConfig(ArgRunnable<JavaTask> startVmConfig) {
        try {
            this.startVmConfig = startVmConfig;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArgRunnable<JavaTask> getStartVmConfig() {
        try {
            return this.startVmConfig;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject getParent() {
        try {
            return this.parent;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getWeaverJar() {
        try {
            return this.weaverJar;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public JavaCommand getJavaCommand() {
        try {
            return this.javaCommand;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$0(DispatchFeature arg0) {
        try {
            return arg0.parent;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ JavaCommand access$1(DispatchFeature arg0) {
        try {
            return arg0.javaCommand;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ boolean access$2(DispatchFeature arg0) {
        try {
            return arg0.isInProjectMain();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ void access$3(DispatchFeature arg0) {
        try {
            arg0.startProjectMainVm();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private static final /* synthetic */ void initBootstrap_aroundBody0(DispatchFeature this_, String mainClass, String mainMemory) {
        this_.mainClass = mainClass;
        this_.mainMemory = mainMemory;
    }

    private static final /* synthetic */ void initBootstrap_aroundBody1$advice(DispatchFeature this_, String mainClass, String mainMemory, UserOverride ajc$aspectInstance, DispatchFeature feature, String memory, AroundClosure ajc$aroundClosure) {
        String propmem = feature.getParent().getProperties().getMainMemory().getValue();
        String override = propmem.length() > 0 ? propmem : memory;
        Logger logger = feature.getParent().getLogger();
        logger.info((Object)("setting main maxmemory to " + override));
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = override;
        DispatchFeature dispatchFeature = feature;
        DispatchFeature.initBootstrap_aroundBody0(dispatchFeature, mainClass, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Dispatcher
    implements ArgRunnable<Instruction> {
        private Dispatcher() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        @Override
        public void run(Instruction instruction) {
            try {
                CommandStore commandStore = DispatchFeature.access$0(DispatchFeature.this).getCommandStore();
                InstructionChain instructionChain = DispatchFeature.access$0(DispatchFeature.this).getInstructionChain();
                String name = instruction.getName();
                Command command = commandStore.getCommand(name);
                if (command != null) {
                    command.execute(instruction);
                    if (command.equals(DispatchFeature.access$1(DispatchFeature.this))) {
                        instructionChain.breakVisit();
                    }
                } else {
                    if (DispatchFeature.access$2(DispatchFeature.this)) {
                        StringBuilder reason = new StringBuilder();
                        reason.append("the following instruction isn't recognized: \"");
                        reason.append(instruction.getText());
                        reason.append("\"");
                        throw new InformationException(reason.toString());
                    }
                    DispatchFeature.access$3(DispatchFeature.this);
                    instructionChain.breakVisit();
                }
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }

    private static final class StartVmException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StartVmException(String message) {
            super(message);
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

