/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import org.aspectj.lang.SoftException;
import protoj.lang.Command;
import protoj.lang.PropertyInfo;
import protoj.lang.ResourceFeature;
import protoj.lang.StandardProject;

public final class InfoFeature {
    private final StandardProject parent;
    private final String versionInfo;

    public InfoFeature(StandardProject parent, String versionInfo) {
        try {
            this.parent = parent;
            this.versionInfo = versionInfo;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void reportProjectHelp() {
        try {
            ResourceFeature feature = this.parent.getResourceFeature();
            String resourcePath = "/protoj-common/language/english/project.txt";
            String text = feature.filterResourceToString(resourcePath);
            System.out.println(text);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void reportCommandHelp(Command command) {
        try {
            System.out.println(command.getHelpText());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void reportPropertyHelp(PropertyInfo property) {
        try {
            System.out.println(property.getHelpText());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void reportVersion() {
        try {
            System.out.println(this.versionInfo);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

