/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.aspectj.lang.SoftException;
import protoj.lang.Instruction;
import protoj.lang.internal.InstructionChainArgs;
import protoj.util.ArgRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstructionChain {
    private LinkedHashMap<String, Instruction> commandInstructions;
    private List<String> jvmArgs;
    private File rootDir;
    private String scriptName;
    private Instruction initInstruction;
    private Instruction optsInstruction;
    private boolean breakVisit;

    public InstructionChain(String[] args) {
        try {
            new InstructionChainArgs(this, args).initChain();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public InstructionChain(File rootDir, String scriptName) {
        try {
            this.init(rootDir, scriptName);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void init(File rootDir, String scriptName) {
        try {
            this.rootDir = rootDir.getCanonicalFile();
            this.scriptName = scriptName;
            this.commandInstructions = new LinkedHashMap();
            this.jvmArgs = new ArrayList<String>();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public List<String> getJvmArgs() {
        try {
            return Collections.unmodifiableList(this.jvmArgs);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void addJvmArg(String jvmArg) {
        try {
            this.jvmArgs.add(jvmArg);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Instruction addInstruction(String name, String options) {
        try {
            Instruction instruction = new Instruction(name, options);
            if (instruction.isInitInstruction()) {
                this.initInstruction = instruction;
            } else if (instruction.isOptsInstruction()) {
                this.optsInstruction = instruction;
            } else {
                this.commandInstructions.put(name, instruction);
            }
            return instruction;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Instruction getInitInstruction() {
        try {
            return this.initInstruction;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Instruction getOptsInstruction() {
        try {
            return this.optsInstruction;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Instruction remove(String name) {
        try {
            return (Instruction)this.commandInstructions.remove(name);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void visitAndRemove(ArgRunnable<Instruction> visitor) {
        try {
            this.breakVisit = false;
            ArrayList instructions = new ArrayList();
            instructions.addAll(((HashMap)this.commandInstructions).values());
            Iterator values = instructions.listIterator();
            while (values.hasNext() && !this.breakVisit) {
                Instruction instruction = (Instruction)values.next();
                visitor.run(instruction);
                values.remove();
                this.remove(instruction.getName());
            }
            this.commandInstructions.clear();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void breakVisit() {
        try {
            this.breakVisit = true;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String[] createArgsAndRemove(boolean skipFirst) {
        try {
            Collection<Instruction> values;
            if (skipFirst) {
                ArrayList<Instruction> skippedList = new ArrayList<Instruction>();
                skippedList.addAll(((HashMap)this.commandInstructions).values());
                skippedList.remove(0);
                values = skippedList;
            } else {
                values = ((HashMap)this.commandInstructions).values();
            }
            String[] createMainArgs = this.createMainArgsAsArray(values);
            return createMainArgs;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private String[] createMainArgsAsArray(Collection<Instruction> commandInstructions) {
        try {
            boolean containsDefinitions;
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.getInitInstruction().getText());
            boolean bl = containsDefinitions = commandInstructions.size() > 0;
            if (containsDefinitions) {
                for (Instruction definition : commandInstructions) {
                    args.add(definition.getText());
                }
            }
            if (this.getOptsInstruction() != null) {
                args.add(this.getOptsInstruction().getText());
            }
            return args.toArray(new String[0]);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String[] createMainArgs(String name, String opts) {
        try {
            Instruction command = new Instruction(name, opts);
            ArrayList<Instruction> commands = new ArrayList<Instruction>();
            commands.add(command);
            return this.createMainArgsAsArray(commands);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getRootDir() {
        try {
            return this.rootDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getScriptName() {
        try {
            return this.scriptName;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

