/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import org.apache.ivy.ant.IvyFindRevision;
import org.apache.ivy.ant.IvyListModules;
import org.apache.ivy.ant.IvyMakePom;
import org.apache.tools.ant.Task;
import org.aspectj.lang.SoftException;
import protoj.lang.StandardProject;
import protoj.util.AntTarget;

public final class IvyFeature {
    private String organization;
    private String module;
    private String revision;
    private String revisionResult;
    private String branch;
    private String settingsRef;
    private String matcher;
    private String value;
    private File ivyFile;
    private File pomFile;

    public IvyFeature(StandardProject parent) {
        try {
            this.ivyFile = new File(parent.getLayout().getConfDir(), "ivy.xml");
            this.pomFile = new File(parent.getLayout().getTargetDir(), "pom.xml");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void listmodules(String organization, String module, String branch, String revision, String matcher, String value, String settingsRef) {
        try {
            this.organization = organization;
            this.module = module;
            this.branch = branch;
            this.revision = revision;
            this.matcher = matcher;
            this.value = value;
            this.settingsRef = settingsRef;
            AntTarget target = new AntTarget("ivy-feature");
            target.initLogging(2);
            IvyListModules listmodules = new IvyListModules();
            target.addTask((Task)listmodules);
            listmodules.setTaskName("findrevision");
            if (organization != null) {
                listmodules.setOrganisation(organization);
            }
            if (module != null) {
                listmodules.setModule(module);
            }
            if (branch != null) {
                listmodules.setBranch(branch);
            }
            if (revision != null) {
                listmodules.setRevision(revision);
            }
            if (matcher != null) {
                listmodules.setMatcher(matcher);
            }
            if (value != null) {
                listmodules.setValue(value);
            }
            String string = "modules.[module]";
            listmodules.setProperty(string);
            target.execute();
            System.out.println(target.getProject().getProperty(string));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void findrevision(String organization, String module, String branch, String revision, String settingsRef) {
        try {
            this.organization = organization;
            this.module = module;
            this.branch = branch;
            this.revision = revision;
            this.settingsRef = settingsRef;
            AntTarget target = new AntTarget("ivy-feature");
            target.initLogging(2);
            IvyFindRevision findrevision = new IvyFindRevision();
            target.addTask((Task)findrevision);
            findrevision.setTaskName("findrevision");
            if (organization != null) {
                findrevision.setOrganisation(organization);
            }
            if (module != null) {
                findrevision.setModule(module);
            }
            if (branch != null) {
                findrevision.setBranch(branch);
            }
            if (revision != null) {
                findrevision.setRevision(revision);
            }
            target.execute();
            this.revisionResult = target.getProject().getProperty(findrevision.getProperty());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void makepom(String settingsRef) {
        try {
            AntTarget target = new AntTarget("ivy-feature");
            target.initLogging(2);
            IvyMakePom makepom = new IvyMakePom();
            target.addTask((Task)makepom);
            makepom.setTaskName("makepom");
            makepom.setIvyFile(this.ivyFile);
            makepom.setPomFile(this.pomFile);
            IvyMakePom.Mapping mapping = makepom.createMapping();
            mapping.setConf("compile");
            mapping.setScope("compile");
            target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getOrganization() {
        try {
            return this.organization;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getModule() {
        try {
            return this.module;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getRevision() {
        try {
            return this.revision;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getBranch() {
        try {
            return this.branch;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getSettingsRef() {
        try {
            return this.settingsRef;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getMatcher() {
        try {
            return this.matcher;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getValue() {
        try {
            return this.value;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getRevisionResult() {
        try {
            return this.revisionResult;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getIvyFile() {
        try {
            return this.ivyFile;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getPomFile() {
        try {
            return this.pomFile;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

