/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.types.DirSet;
import org.aspectj.lang.SoftException;
import protoj.lang.ArchiveEntry;
import protoj.lang.ArchiveFeature;
import protoj.lang.ProjectLayout;
import protoj.lang.internal.InformationException;
import protoj.util.ArgRunnable;
import protoj.util.AssembleTask;
import protoj.util.JavadocTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavadocArchive {
    private final ArchiveFeature parent;
    private TreeMap<String, JavadocEntry> entries;
    private AssembleTask currentAssembleTask;
    private ArchiveEntry<JavadocArchive> currentEntry;
    private File workingDir;
    private JavadocTask javadocTask;

    public JavadocArchive(ArchiveFeature parent) {
        try {
            this.entries = new TreeMap();
            this.parent = parent;
            this.workingDir = new File(parent.getProject().getLayout().getArchiveDir(), "javadoc-archive");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void addEntry(String name, String manifest, String includes, String excludes, String memory) {
        try {
            if (memory == null) {
                throw new InformationException("please specify a non null value for javadoc memory");
            }
            String fileName = String.format("%s-%s.jar", name, this.parent.getLayout().getJavadocPostfix());
            JavadocEntry entry = new JavadocEntry(this.parent, name, fileName, manifest, includes, excludes, memory);
            this.entries.put(name, entry);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createArchives() {
        try {
            Set<String> keys = this.entries.keySet();
            for (String key : keys) {
                this.createArchive(key);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createArchive(String name) {
        try {
            ProjectLayout layout = this.parent.getProject().getLayout();
            this.getWorkingDir().mkdirs();
            JavadocEntry entry = this.entries.get(name);
            String memory = entry.getMemory();
            File srcDir = layout.getJavaDir();
            this.javadocTask = new JavadocTask(srcDir, this.getWorkingDir());
            this.javadocTask.initLogging();
            this.javadocTask.getjavadoc().setMaxmemory(memory);
            DirSet packageSet = this.javadocTask.getPackageSet();
            packageSet.setDefaultexcludes(true);
            ArgRunnable<JavadocArchive> config = entry.getArchiveEntry().getConfig();
            this.currentAssembleTask = entry.getArchiveEntry().createAssembleTask(this.getWorkingDir());
            if (config != null) {
                config.run(this);
            }
            this.javadocTask.execute();
            this.currentAssembleTask.execute();
            FileUtils.deleteDirectory((File)this.getWorkingDir());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void visit(ArgRunnable<JavadocEntry> visitor) {
        try {
            Collection<JavadocEntry> values = this.entries.values();
            for (JavadocEntry entry : values) {
                visitor.run(entry);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public JavadocEntry getEntry(String name) {
        try {
            return this.entries.get(name);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public JavadocTask getJavadocTask() {
        try {
            return this.javadocTask;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getWorkingDir() {
        try {
            return this.workingDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public AssembleTask getCurrentAssembleTask() {
        try {
            return this.currentAssembleTask;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArchiveEntry<JavadocArchive> getCurrentEntry() {
        try {
            return this.currentEntry;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class JavadocEntry {
        private ArchiveEntry<JavadocArchive> archiveEntry;
        private String memory;

        public JavadocEntry(ArchiveFeature parent, String name, String fileName, String manifest, String includes, String excludes, String memory) {
            try {
                this.archiveEntry = new ArchiveEntry(name, parent, fileName, manifest, includes, excludes);
                this.memory = memory;
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void initConfig(ArgRunnable<JavadocArchive> config) {
            try {
                this.archiveEntry.initConfig(config);
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public String getMemory() {
            try {
                return this.memory;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public ArchiveEntry<JavadocArchive> getArchiveEntry() {
            try {
                return this.archiveEntry;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

