/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import org.apache.tools.ant.taskdefs.Tar;
import org.aspectj.lang.SoftException;
import protoj.lang.ArchiveFeature;
import protoj.lang.ProjectLayout;
import protoj.util.ArgRunnable;
import protoj.util.TarTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectArchive {
    private ArchiveFeature parent;
    private String userName;
    private String group;
    private boolean noSrc;
    private boolean noClasses;
    private boolean isGlobalRwx;
    private TarTask tarTask;
    private ArgRunnable<ProjectArchive> config;
    private final String prefix;
    private File tarStem;
    private ProjectLayout layout;

    public ProjectArchive(ArchiveFeature parent, String name, String prefix, String userName, String group) {
        try {
            this.parent = parent;
            this.layout = parent.getProject().getLayout();
            this.tarStem = new File(this.layout.getArchiveDir(), name);
            this.prefix = prefix;
            this.userName = userName;
            this.group = group;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initConfig(ArgRunnable<ProjectArchive> config) {
        try {
            this.config = config;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArchiveFeature getParent() {
        try {
            return this.parent;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getUserName() {
        try {
            return this.userName;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getGroup() {
        try {
            return this.group;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getName() {
        try {
            return this.tarStem.getName();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getPrefix() {
        try {
            return this.prefix;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isNoSrc() {
        try {
            return this.noSrc;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isNoClasses() {
        try {
            return this.noClasses;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isGlobalRwx() {
        try {
            return this.isGlobalRwx;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Tar getAntTar() {
        try {
            return this.tarTask.getTar();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getUncompressedPath() {
        try {
            return String.valueOf(this.tarStem.getAbsolutePath()) + ".tar";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getArchivePath() {
        try {
            return String.valueOf(this.getUncompressedPath()) + ".gz";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getArchiveFile() {
        try {
            return new File(this.getArchivePath());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void addFileSet(String fileMode, String dirMode, String includes, String excludes) {
        try {
            if (this.isGlobalRwx()) {
                fileMode = "777";
                dirMode = "777";
            }
            File rootDir = this.layout.getRootDir();
            this.tarTask.addFileSet(rootDir, this.getPrefix(), fileMode, dirMode, this.userName, this.group, includes, excludes);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createArchive(boolean noSrc, boolean noClasses, boolean isGlobalRwx) {
        try {
            File archiveDir = this.layout.getArchiveDir();
            archiveDir.mkdirs();
            this.noSrc = noSrc;
            this.noClasses = noClasses;
            this.isGlobalRwx = isGlobalRwx;
            this.tarTask = new TarTask(this.tarStem.getParent(), this.tarStem.getName());
            this.initTarTask();
            if (this.config != null) {
                this.config.run(this);
            }
            this.tarTask.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void initTarTask() {
        try {
            File logFile = this.layout.getLogFile();
            this.tarTask.initLogging();
            this.addFileSet("544", "755", String.valueOf(this.layout.getBinDir().getName()) + "/**", null);
            this.addFileSet("444", "755", String.valueOf(this.layout.getConfDir().getName()) + "/**", this.getConfExcludesPattern());
            this.addFileSet("444", "755", String.valueOf(this.layout.getDocsDir().getName()) + "/**", null);
            this.addFileSet("444", "755", String.valueOf(this.layout.getLibDir().getName()) + "/**", this.getLibExcludesPattern());
            String excludeLogFile = this.getLogExcludesPattern(logFile);
            this.addFileSet("644", "755", String.valueOf(this.layout.getLogDir().getName()) + "/**", excludeLogFile);
            if (!this.noSrc) {
                this.addFileSet("444", "755", String.valueOf(this.layout.getSrcDir().getName()) + "/**", null);
            }
            if (!this.noClasses) {
                this.addFileSet("444", "755", String.valueOf(this.layout.getClassesDir().getName()) + "/**", null);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getLogExcludesPattern(File logFile) {
        try {
            return String.valueOf(logFile.getParentFile().getName()) + "/" + logFile.getName();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getConfExcludesPattern() {
        try {
            String confDirName = this.layout.getConfDir().getName();
            return String.valueOf(confDirName) + "/*.properties";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getLibExcludesPattern() {
        try {
            String libDirName = this.layout.getLibDir().getName();
            return String.format("%s/*%s.jar %s/*%s.jar %s/*%s.jar", libDirName, this.layout.getJavadocPostfix(), libDirName, this.layout.getSourcePostfix(), libDirName, this.layout.getSrcPostfix());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

