/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.aspectj.lang.SoftException;
import protoj.util.AntTarget;
import protoj.util.ArgRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectLayout {
    private final File shellScript;
    private final File rootDir;
    private final File binDir;
    private final File docsDir;
    private final File archiveDir;
    private final File srcDir;
    private final File javaDir;
    private final File libDir;
    private final File targetDir;
    private final File classesDir;
    private final File resourcesDir;
    private final File manifestDir;
    private final File logDir;
    private final File confDir;
    private final File propertiesFile;
    private final File logFile;
    private final File junitReportsDir;
    private final ArgRunnable<Path> classpathConfig;
    private String scriptName;
    public String sourcePostfix;
    public String srcPostfix;
    private String javadocPostfix;

    public ProjectLayout(File rootDir, String scriptName) {
        try {
            this.classpathConfig = new DefaultClasspathConfig();
            this.rootDir = rootDir;
            this.binDir = new File(this.getRootDir(), "bin");
            this.scriptName = this.createScriptName(scriptName);
            this.shellScript = new File(this.getBinDir(), this.getScriptName()).getCanonicalFile();
            this.docsDir = new File(this.getRootDir(), "docs");
            this.srcDir = new File(this.getRootDir(), "src");
            this.logDir = new File(this.getRootDir(), "log");
            this.confDir = new File(this.getRootDir(), "conf");
            this.libDir = new File(this.getRootDir(), "lib");
            this.classesDir = new File(this.getRootDir(), "classes");
            this.javaDir = new File(this.getSrcDir(), "java");
            this.resourcesDir = new File(this.getSrcDir(), "resources");
            this.manifestDir = new File(this.getSrcDir(), "manifest");
            this.targetDir = new File(this.getRootDir(), "target");
            this.archiveDir = new File(this.getTargetDir(), "archive");
            this.junitReportsDir = new File(this.getTargetDir(), "junit-reports");
            this.logFile = new File(this.getLogDir(), "protoj.log");
            this.propertiesFile = new File(this.getConfDir(), "all.project.properties");
            this.sourcePostfix = "sources";
            this.srcPostfix = "src";
            this.javadocPostfix = "javadoc";
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private String createScriptName(String name) {
        try {
            String scriptName;
            if (name.contains(".")) {
                scriptName = name;
            } else {
                String osName = System.getProperty("os.name").toUpperCase();
                boolean isWindows = osName.indexOf("WINDOWS") >= 0;
                scriptName = isWindows ? String.valueOf(name) + ".bat" : String.valueOf(name) + ".sh";
            }
            return scriptName;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createPhysicalLayout() {
        try {
            this.getRootDir().mkdirs();
            this.getBinDir().mkdirs();
            this.getDocsDir().mkdirs();
            this.getSrcDir().mkdirs();
            this.getLogDir().mkdirs();
            this.getConfDir().mkdirs();
            this.getLibDir().mkdirs();
            this.getJavaDir().mkdirs();
            this.getResourcesDir().mkdirs();
            this.getManifestDir().mkdirs();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void relaxPermissions() {
        try {
            AntTarget target = new AntTarget("relax-permissions");
            Chmod chmod = new Chmod();
            chmod.setTaskName("sample-permissions");
            target.addTask((Task)chmod);
            chmod.setDir(this.getRootDir().getParentFile());
            chmod.setIncludes(String.valueOf(this.getRootName()) + "/**/*.*");
            chmod.setPerm("777");
            target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getRootPath() {
        try {
            return this.getRootDir().getAbsolutePath();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getRootDir() {
        try {
            return this.rootDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getRootName() {
        try {
            return this.getRootDir().getName();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getBinDir() {
        try {
            return this.binDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getShellScript() {
        try {
            return this.shellScript;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getScriptName() {
        try {
            return this.scriptName;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getDocsDir() {
        try {
            return this.docsDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getArchiveDir() {
        try {
            return this.archiveDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getSrcDir() {
        try {
            return this.srcDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getLogDir() {
        try {
            return this.logDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getLogFile() {
        try {
            return this.logFile;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getPropertiesFile() {
        try {
            return this.propertiesFile;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getConfDir() {
        try {
            return this.confDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getJavaDir() {
        try {
            return this.javaDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getResourcesDir() {
        try {
            return this.resourcesDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getManifestDir() {
        try {
            return this.manifestDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getLibDir() {
        try {
            return this.libDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getTargetDir() {
        try {
            return this.targetDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getClassesDir() {
        try {
            return this.classesDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getJunitReportsDir() {
        try {
            return this.junitReportsDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getJar(String jarName) {
        try {
            return new File(this.getLibDir(), String.valueOf(jarName) + ".jar");
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getManifest(String name) {
        try {
            return new File(this.getManifestDir(), String.valueOf(name) + ".MF");
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArgRunnable<Path> getClasspathConfig() {
        try {
            return this.classpathConfig;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getSourcePostfix() {
        try {
            return this.sourcePostfix;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getSrcPostfix() {
        try {
            return this.srcPostfix;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getJavadocPostfix() {
        try {
            return this.javadocPostfix;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getRelativePath(File child) {
        try {
            int relativePathPos = this.getRootDir().getAbsolutePath().length();
            return child.getAbsolutePath().substring(relativePathPos + 1);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String loadLog() {
        try {
            return FileUtils.readFileToString((File)this.getLogFile());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultClasspathConfig
    implements ArgRunnable<Path> {
        private DefaultClasspathConfig() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        @Override
        public void run(Path classpath) {
            try {
                ProjectLayout.this.getClassesDir().mkdirs();
                DirSet classes = new DirSet();
                classes.setDir(ProjectLayout.this.getClassesDir().getParentFile());
                classes.setIncludes(ProjectLayout.this.getClassesDir().getName());
                classpath.addDirset(classes);
                FileSet libs = new FileSet();
                libs.setDir(ProjectLayout.this.getLibDir());
                String libExcludesPattern = String.format("*%s.jar *%s.jar *%s.jar", ProjectLayout.this.getJavadocPostfix(), ProjectLayout.this.getSourcePostfix(), ProjectLayout.this.getSrcPostfix());
                libs.setExcludes(libExcludesPattern);
                classpath.addFileset(libs);
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

