/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import org.aspectj.lang.SoftException;
import protoj.lang.PropertyStore;

public final class PropertyInfo {
    private String key;
    private String emptyDefault;
    private String missingDefault;
    private String description;
    private final PropertyStore store;

    public PropertyInfo(PropertyStore store, String key, String missingDefault, String emptyDefault, String description) {
        try {
            this.store = store;
            this.key = key;
            this.missingDefault = missingDefault;
            this.emptyDefault = emptyDefault;
            this.description = description;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getKey() {
        try {
            return this.key;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getValue() {
        try {
            String value = this.store.getConfig().getString(this.key, this.missingDefault);
            if (value.equals("")) {
                value = this.emptyDefault;
            }
            return value;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getMandatoryValue() {
        try {
            String value = this.getValue();
            if (value.length() == 0) {
                String message = "please provide a value for the property " + this.getKey();
                throw new RuntimeException(message);
            }
            return value;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean getBooleanValue() {
        try {
            String value = this.getValue();
            return value != null ? Boolean.valueOf(Boolean.parseBoolean(value)) : null;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public int getIntegerValue() {
        try {
            String value = this.getValue();
            return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getEmptyDefault() {
        try {
            return this.emptyDefault;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getMissingDefault() {
        try {
            return this.missingDefault;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getDescription() {
        try {
            return this.description;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String createJvmArg(String value) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("-D");
            builder.append(this.getKey());
            if (value != null) {
                builder.append("=");
                builder.append(value);
            }
            return builder.toString();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getHelpText() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("Name: ");
            builder.append(this.getKey());
            builder.append("\n\n");
            builder.append(this.getDescription());
            builder.append("\n\nWhen the key is not specified the application assumes a value of '");
            builder.append(this.getMissingDefault());
            builder.append("'");
            builder.append("\nWhen the key is specified, but not assigned a value, the application assumes a value of '");
            builder.append(this.getEmptyDefault());
            builder.append("'");
            builder.append("\n");
            return builder.toString();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

