/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.aspectj.lang.SoftException;
import protoj.lang.PropertyInfo;
import protoj.lang.StandardProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyStore {
    private HashMap<String, PropertyInfo> infos;
    private File confDir;
    private Configuration config;

    public PropertyStore(StandardProject parent) {
        try {
            this.infos = new HashMap();
            this.confDir = parent.getLayout().getConfDir();
            this.config = this.createConfig();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private Configuration createConfig() {
        try {
            final CompositeConfiguration config = new CompositeConfiguration();
            this.confDir.listFiles(new FilenameFilter(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                public boolean accept(File dir, String name) {
                    try {
                        if (name.endsWith(".properties")) {
                            File file = new File(dir, name);
                            config.addConfiguration((Configuration)new PropertiesConfiguration(file));
                        }
                        return true;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            config.addConfiguration((Configuration)new SystemConfiguration());
            return config.interpolatedConfiguration();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo addInfo(String key, String missingDefault, String emptyDefault, String description) {
        try {
            PropertyInfo info = new PropertyInfo(this, key, missingDefault, emptyDefault, description);
            this.infos.put(key, info);
            return info;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo addInfo(String key, String description) {
        try {
            return this.addInfo(key, "", "", description);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Collection<PropertyInfo> getInfos() {
        try {
            return Collections.unmodifiableCollection(this.infos.values());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getInfo(String key) {
        try {
            return this.infos.get(key);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getLazyInfo(String key, String description, String missingDefault, String emptyDefault) {
        try {
            PropertyInfo info = this.getInfo(key);
            if (info == null) {
                info = this.addInfo(key, missingDefault, emptyDefault, description);
            }
            return info;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Configuration getConfig() {
        try {
            return this.config;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

