/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.varia.NullAppender;
import org.aspectj.lang.SoftException;
import protoj.lang.StandardProject;
import protoj.lang.internal.ProtoExceptionHandler;

public final class ProtoLogger {
    private String consolePattern;
    private String filePattern;
    private Logger protoLogger;
    private Logger antLogger;

    public ProtoLogger(StandardProject parent) {
        try {
            boolean isEmpty;
            this.consolePattern = "%m%n";
            this.filePattern = "%d{HH:mm:ss,SSS} [%t] %m%n";
            File logFile = parent.getLayout().getLogFile();
            this.protoLogger = Logger.getLogger((String)logFile.getAbsolutePath());
            this.antLogger = Logger.getLogger((String)"org.apache.tools.ant");
            boolean bl = isEmpty = !Logger.getRootLogger().getAllAppenders().hasMoreElements();
            if (isEmpty) {
                Logger.getRootLogger().addAppender((Appender)new NullAppender());
            }
            this.setFileAppenderEnabled(true, logFile.getAbsolutePath());
            ProtoExceptionHandler.aspectOf().ajc$afterReturning$protoj_lang_internal_UncaughtExceptionPolicy$2$b2b20224(this);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ConsoleAppender setConsoleAppenderEnabled(boolean enable) {
        try {
            boolean appenderExists;
            String name = "proto.consoleAppender";
            Appender appender = Logger.getRootLogger().getAppender(name);
            boolean bl = appenderExists = appender != null;
            if (enable) {
                if (!appenderExists) {
                    appender = new ConsoleAppender((Layout)new PatternLayout(this.getConsolePattern()), "System.out");
                    appender.setName(name);
                    Logger.getRootLogger().addAppender(appender);
                }
            } else if (appenderExists) {
                Logger.getRootLogger().removeAppender(appender);
            }
            return (ConsoleAppender)this.protoLogger.getAppender(name);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public RollingFileAppender setFileAppenderEnabled(boolean enable, String logFile) {
        try {
            boolean appenderExists;
            String name = "proto.fileAppender";
            Appender appender = Logger.getRootLogger().getAppender(name);
            boolean bl = appenderExists = appender != null;
            if (enable) {
                if (!appenderExists) {
                    appender = new RollingFileAppender((Layout)new PatternLayout(this.getFilePattern()), logFile);
                    appender.setName(name);
                    Logger.getRootLogger().addAppender(appender);
                }
            } else if (appenderExists) {
                Logger.getRootLogger().removeAppender(appender);
            }
            return (RollingFileAppender)appender;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getConsolePattern() {
        try {
            return this.consolePattern;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getFilePattern() {
        try {
            return this.filePattern;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Logger getProtoLogger() {
        try {
            return this.protoLogger;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Logger getAntLogger() {
        try {
            return this.antLogger;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void setLevel(Level level) {
        try {
            Logger.getRootLogger().setLevel(level);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

