/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import org.apache.maven.artifact.ant.AttachedArtifact;
import org.apache.maven.artifact.ant.Authentication;
import org.apache.maven.artifact.ant.DeployTask;
import org.apache.maven.artifact.ant.InstallWagonProviderTask;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.tools.ant.Task;
import org.aspectj.lang.SoftException;
import protoj.lang.ArchiveEntry;
import protoj.lang.ArchiveFeature;
import protoj.lang.ClassesArchive;
import protoj.lang.JavadocArchive;
import protoj.lang.ResourceFeature;
import protoj.lang.SourceArchive;
import protoj.lang.StandardProject;
import protoj.lang.internal.InformationException;
import protoj.util.AntTarget;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PublishFeature {
    private final StandardProject parent;
    private ArgRunnable<PublishFeature> config;
    private DeployTask currentDeployTask;
    private Pom currentPom;
    private String providerArtifactId;
    private String providerVersion;
    private String url;
    private File workingDir;
    private ClassesArchive.ClassesEntry currentClassesEntry;

    public PublishFeature(StandardProject parent, String url) {
        try {
            this.parent = parent;
            this.url = url;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initConfig(ArgRunnable<PublishFeature> config) {
        try {
            this.config = config;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initProvider(String artifactId, String version) {
        try {
            this.providerArtifactId = artifactId;
            this.providerVersion = version;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void deployAll(final String userName, final String key, final String password, final String passphrase) {
        try {
            ArchiveFeature archive = this.parent.getArchiveFeature();
            ClassesArchive classesArchive = archive.getClassesArchive();
            classesArchive.visit(new ArgRunnable<ClassesArchive.ClassesEntry>(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                @Override
                public void run(ClassesArchive.ClassesEntry entry) {
                    try {
                        String pomResource = entry.getPomResource();
                        if (pomResource != null) {
                            PublishFeature.this.deploy(entry.getArchiveEntry().getName(), userName, key, password, passphrase);
                        }
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void deploy(String artifactName, String userName, String key, String password, String passphrase) {
        try {
            AntTarget target = new AntTarget("publish");
            target.initLogging(2);
            String pomId = "protoj.project";
            this.maybeAddProvider(target);
            ClassesArchive archive = this.parent.getArchiveFeature().getClassesArchive();
            this.currentClassesEntry = archive.getEntry(artifactName);
            this.currentDeployTask = new DeployTask();
            this.currentPom = this.addPomTask(target, pomId);
            this.assignClassesArtifact(target, pomId, userName, key);
            this.attachJavadocArtifact(artifactName);
            this.attachSourcesArtifact(artifactName);
            this.maybeAttachSignatureFile(this.currentPom.getFile(), null, "pom");
            if (this.config != null) {
                this.config.run(this);
            }
            target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private Pom addPomTask(AntTarget target, String pomId) {
        try {
            ClassesArchive.ClassesEntry entry = this.getCurrentClassesEntry();
            String pomResource = entry.getPomResource();
            if (pomResource == null) {
                String name = entry.getArchiveEntry().getName();
                throw new InformationException("no pom specified: please specify a pom resource for the artifact called " + name);
            }
            ResourceFeature feature = this.parent.getResourceFeature();
            File confDir = this.parent.getLayout().getConfDir();
            File pomFile = feature.filterResourceToDir(pomResource, confDir);
            Pom pom = new Pom();
            pom.setTaskName("publish-pom");
            target.addTask((Task)pom);
            pom.setId(pomId);
            pom.setFile(pomFile);
            return pom;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void assignClassesArtifact(AntTarget target, String pomId, String userName, String key) {
        try {
            File classes = this.getCurrentClassesEntry().getArchiveEntry().getArtifact();
            if (classes == null) {
                throw new InformationException("no artifact specified: please specify the name of an artifact to publish");
            }
            if (!classes.exists()) {
                throw new InformationException("no artifact found: couldn't find an artifact at " + classes.getAbsolutePath());
            }
            RemoteRepository repo = new RemoteRepository();
            repo.setUrl(this.url);
            Authentication authentication = new Authentication();
            authentication.setUserName(userName);
            if (key != null) {
                authentication.setPrivateKey(key);
            }
            repo.addAuthentication(authentication);
            this.currentDeployTask = new DeployTask();
            this.currentDeployTask.addRemoteRepository(repo);
            this.currentDeployTask.setTaskName("publish-deploy");
            target.addTask((Task)this.currentDeployTask);
            this.currentDeployTask.setFile(classes);
            this.currentDeployTask.setPomRefId(pomId);
            this.maybeAttachSignatureFile(classes, null, "jar");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void maybeAttachSignatureFile(File artifact, String classifier, String extension) {
        try {
            String gpgOptions = this.getCurrentClassesEntry().getGpgOptions();
            if (gpgOptions != null) {
                AttachedArtifact attach = this.currentDeployTask.createAttach();
                File artifactSig = this.createSig(gpgOptions, artifact);
                attach.setFile(artifactSig);
                if (classifier != null) {
                    attach.setClassifier(String.valueOf(classifier) + "." + extension);
                    attach.setType("asc");
                } else {
                    attach.setClassifier(null);
                    attach.setType(String.valueOf(extension) + ".asc");
                }
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private File createSig(String gpgOptions, File artifact) {
        try {
            String artifactSigName = String.valueOf(artifact.getName()) + ".asc";
            File workingDir = this.getWorkingDir();
            File artifactSig = new File(workingDir, artifactSigName);
            String line = String.format(gpgOptions, artifact.getAbsolutePath(), artifactSig.getAbsolutePath());
            return this.executeGpgCommand(line, artifact, artifactSig);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private File executeGpgCommand(String options, File artifact, File artifactSig) {
        try {
            CommandTask task = new CommandTask(this.getWorkingDir(), "gpg", options, null);
            task.initSpawn(false);
            task.execute();
            return artifactSig;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void maybeAddProvider(AntTarget target) {
        try {
            if (this.isUsingProvider()) {
                InstallWagonProviderTask provider = new InstallWagonProviderTask();
                provider.setTaskName("publish-wagon");
                target.addTask((Task)provider);
                provider.setArtifactId(this.providerArtifactId);
                provider.setVersion(this.providerVersion);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void attachSourcesArtifact(String artifactName) {
        try {
            ArchiveFeature feature = this.parent.getArchiveFeature();
            SourceArchive archive = feature.getSourceArchive();
            ArchiveEntry<SourceArchive> entry = archive.getEntry(artifactName);
            if (entry != null) {
                File artifact = entry.getArtifact();
                AttachedArtifact attach = this.currentDeployTask.createAttach();
                attach.setFile(artifact);
                attach.setClassifier("sources");
                this.maybeAttachSignatureFile(artifact, "sources", "jar");
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void attachJavadocArtifact(String artifactName) {
        try {
            ArchiveFeature feature = this.parent.getArchiveFeature();
            JavadocArchive archive = feature.getJavadocArchive();
            JavadocArchive.JavadocEntry entry = archive.getEntry(artifactName);
            if (entry != null) {
                File artifact = entry.getArchiveEntry().getArtifact();
                AttachedArtifact attach = this.currentDeployTask.createAttach();
                attach.setFile(artifact);
                attach.setClassifier("javadoc");
                this.maybeAttachSignatureFile(artifact, "javadoc", "jar");
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject getParent() {
        try {
            return this.parent;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DeployTask getCurrentDeployTask() {
        try {
            return this.currentDeployTask;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ClassesArchive.ClassesEntry getCurrentClassesEntry() {
        try {
            return this.currentClassesEntry;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Pom getCurrentPom() {
        try {
            return this.currentPom;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getUrl() {
        try {
            return this.url;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isUsingProvider() {
        try {
            return this.providerArtifactId != null;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getWorkingDir() {
        try {
            if (this.workingDir == null) {
                this.workingDir = new File(this.parent.getLayout().getTargetDir(), "publish");
                this.workingDir.mkdirs();
            }
            return this.workingDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

