/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.aspectj.lang.SoftException;
import protoj.lang.StandardProject;

public final class ResourceFeature {
    private VelocityEngine velocityEngine;
    private VelocityContext context;
    private final StandardProject parent;

    public ResourceFeature(StandardProject parent) {
        try {
            this.parent = parent;
            this.context = new VelocityContext();
            this.context.put("project", (Object)parent);
            this.context.put("layout", (Object)parent.getLayout());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public VelocityContext getContext() {
        try {
            return this.context;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File filterResourceToDir(String resourcePath, File destDir) {
        try {
            File destFile = new File(destDir, resourcePath);
            return this.copyResourceToFile(resourcePath, destFile, true);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File extractResourceToDir(String resourcePath, File destDir) {
        try {
            File destFile = new File(destDir, resourcePath);
            return this.copyResourceToFile(resourcePath, destFile, false);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File filterResourceToDir(String resourceRoot, String relativePath, File destDir) {
        try {
            String resourcePath = String.valueOf(resourceRoot) + "/" + relativePath;
            File destFile = new File(destDir, relativePath);
            return this.copyResourceToFile(resourcePath, destFile, true);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File extractResourceToDir(String resourceRoot, String relativePath, File destDir) {
        try {
            String resourcePath = String.valueOf(resourceRoot) + "/" + relativePath;
            File destFile = new File(destDir, relativePath);
            return this.copyResourceToFile(resourcePath, destFile, false);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File copyResourceToFile(String resourcePath, File destFile, boolean filter) {
        try {
            if (filter) {
                this.filterResourceToFile(resourcePath, destFile);
            } else {
                this.extractResourceToFile(resourcePath, destFile);
            }
            return destFile;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void extractResourceToFile(String resourcePath, File dest) {
        try {
            InputStream in = this.getClass().getResourceAsStream(resourcePath);
            try {
                FileOutputStream out = FileUtils.openOutputStream((File)dest);
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void filterResourceToFile(String resourcePath, File dest) {
        try {
            VelocityEngine ve = this.getVelocityEngine();
            Template t = ve.getTemplate(resourcePath);
            File destParent = dest.getParentFile();
            if (!destParent.exists()) {
                destParent.mkdirs();
            }
            dest.createNewFile();
            FileWriter writer = new FileWriter(dest);
            t.merge((Context)this.context, (Writer)writer);
            writer.close();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String filterResourceToString(String resourcePath) {
        try {
            VelocityEngine ve = this.getVelocityEngine();
            Template t = ve.getTemplate(resourcePath);
            StringWriter writer = new StringWriter();
            t.merge((Context)this.context, (Writer)writer);
            writer.close();
            return writer.toString();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private VelocityEngine getVelocityEngine() {
        try {
            if (this.velocityEngine == null) {
                this.velocityEngine = new VelocityEngine();
                Properties props = new Properties();
                props.setProperty("resource.loader", "class, file");
                props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                props.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
                props.setProperty("file.resource.loader.path", this.parent.getLayout().getRootPath());
                props.setProperty("file.resource.loader.cache", "false");
                props.setProperty("file.resource.loader.modificationCheckInterval", "2");
                this.velocityEngine.init(props);
            }
            return this.velocityEngine;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

