/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import org.apache.ivy.ant.IvyRetrieve;
import org.apache.maven.artifact.ant.DependenciesTask;
import org.apache.maven.artifact.ant.Pom;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Reference;
import org.aspectj.lang.SoftException;
import protoj.lang.ProjectLayout;
import protoj.lang.ResourceFeature;
import protoj.lang.StandardProject;
import protoj.util.AntTarget;
import protoj.util.ArgRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RetrieveFeature {
    private final StandardProject parent;
    private DependenciesTask dependencies;
    private Copy copyClasses;
    private Copy copyJavadocs;
    private Copy copySources;
    private ArgRunnable<RetrieveFeature> config;
    private IvyRetrieve ivyRetrieve;
    private File ivyFile;
    private File mavenFile;
    private File workingDir;
    private String ivyConfig;
    private String mavenConfig;

    public RetrieveFeature(StandardProject parent) {
        try {
            this.parent = parent;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initMaven(String mavenConfig) {
        try {
            this.mavenConfig = mavenConfig;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initIvy(String ivyConfig) {
        try {
            this.ivyConfig = ivyConfig;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initConfig(ArgRunnable<RetrieveFeature> config) {
        try {
            this.config = config;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void retrieveAll() {
        try {
            this.ivyRetrieve();
            this.mavenRetrieve();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void ivyRetrieve() {
        try {
            if (this.ivyConfig != null) {
                AntTarget target = new AntTarget("ivy-feature");
                target.getProject().setBaseDir(this.parent.getLayout().getRootDir());
                target.initLogging(2);
                this.ivyRetrieve = new IvyRetrieve();
                target.addTask((Task)this.ivyRetrieve);
                this.ivyRetrieve.setTaskName("ivyRetrieve");
                this.ivyRetrieve.setFile(this.getIvyFile());
                if (this.config != null) {
                    this.config.run(this);
                }
                target.execute();
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void mavenRetrieve() {
        try {
            if (this.mavenConfig != null) {
                AntTarget target = new AntTarget("maven-feature");
                target.initLogging(2);
                this.dependencies = this.createDependencies(target);
                String classesDependency = "classes.fileset";
                this.dependencies.setFilesetId(classesDependency);
                this.copyClasses = this.addDependency(target, classesDependency);
                String javadocsDependency = "javadocs.fileset";
                this.dependencies.setJavadocFilesetId(javadocsDependency);
                this.copyJavadocs = this.addDependency(target, javadocsDependency);
                String sourcesDependency = "sources.fileset";
                this.dependencies.setSourcesFilesetId(sourcesDependency);
                this.copySources = this.addDependency(target, sourcesDependency);
                if (this.config != null) {
                    this.config.run(this);
                }
                target.execute();
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private DependenciesTask createDependencies(AntTarget target) {
        try {
            Pom pom = new Pom();
            pom.setTaskName("maven-feature-pom");
            target.addTask((Task)pom);
            pom.setId("protoj.project");
            pom.setFile(this.getMavenFile());
            DependenciesTask dependencies = new DependenciesTask();
            dependencies.setTaskName("maven-feature-dependencies");
            target.addTask((Task)dependencies);
            dependencies.setPomRefId("protoj.project");
            return dependencies;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private Copy addDependency(AntTarget target, String dependency) {
        try {
            ProjectLayout layout = this.parent.getLayout();
            Copy copy = new Copy();
            target.addTask((Task)copy);
            copy.setTaskName("maven-feature-copy-artifact");
            FileSet fileSet = new FileSet();
            copy.addFileset(fileSet);
            Reference dependencyRef = new Reference(target.getProject(), dependency);
            fileSet.setRefid(dependencyRef);
            copy.setTodir(layout.getLibDir());
            copy.setOverwrite(true);
            Mapper flattenMapper = copy.createMapper();
            Mapper.MapperType flattenType = new Mapper.MapperType();
            flattenType.setValue("flatten");
            flattenMapper.setType(flattenType);
            return copy;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject getParent() {
        try {
            return this.parent;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public IvyRetrieve getIvyRetrieve() {
        try {
            return this.ivyRetrieve;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependenciesTask getDependencies() {
        try {
            return this.dependencies;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Copy getCopyClasses() {
        try {
            return this.copyClasses;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Copy getCopyJavadocs() {
        try {
            return this.copyJavadocs;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Copy getCopySources() {
        try {
            return this.copySources;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getIvyFile() {
        try {
            if (this.ivyFile == null) {
                ResourceFeature feature = this.parent.getResourceFeature();
                File confDir = this.parent.getLayout().getConfDir();
                this.ivyFile = feature.filterResourceToDir(this.ivyConfig, confDir);
            }
            return this.ivyFile;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getMavenFile() {
        try {
            if (this.mavenFile == null) {
                ResourceFeature feature = this.parent.getResourceFeature();
                File confDir = this.parent.getLayout().getConfDir();
                this.mavenFile = feature.filterResourceToDir(this.mavenConfig, confDir);
            }
            return this.mavenFile;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getWorkingDir() {
        try {
            if (this.workingDir == null) {
                this.workingDir = new File(this.parent.getLayout().getTargetDir(), "retrieve");
                this.workingDir.mkdirs();
            }
            return this.workingDir;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

