/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import java.util.ArrayList;
import org.aspectj.lang.SoftException;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptSession {
    private File shellScript;
    private CommandTask currentExec;
    private String currentCommand;
    private String currentTag;
    private ArrayList<String> commands;
    private ArrayList<String> tags;
    private ArrayList<ArgRunnable<ScriptSession>> listeners;

    public ScriptSession(File shellScript) {
        try {
            this.commands = new ArrayList();
            this.tags = new ArrayList();
            this.listeners = new ArrayList();
            this.shellScript = shellScript;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void addCommand(String command) {
        try {
            this.addCommand(command, null, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void addCommand(String command, ArgRunnable<ScriptSession> listener, String tag) {
        try {
            this.commands.add(command);
            this.listeners.add(listener);
            this.tags.add(tag);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            File scriptDir = this.shellScript.getParentFile();
            String executable = this.shellScript.getCanonicalPath();
            int i = 0;
            while (i < this.commands.size()) {
                this.currentTag = this.tags.get(i);
                this.currentCommand = this.commands.get(i);
                this.currentExec = new CommandTask(scriptDir, executable, this.currentCommand, null);
                this.currentExec.initSpawn(false);
                this.currentExec.execute();
                ArgRunnable<ScriptSession> currentListener = this.listeners.get(i);
                if (currentListener != null) {
                    currentListener.run(this);
                }
                ++i;
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getShellScript() {
        try {
            return this.shellScript;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public CommandTask getCurrentExec() {
        try {
            return this.currentExec;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getCurrentCommand() {
        try {
            return this.currentCommand;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getCurrentTag() {
        try {
            return this.currentTag;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

