/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.aspectj.lang.SoftException;
import protoj.lang.ArchiveEntry;
import protoj.lang.ArchiveFeature;
import protoj.lang.ProjectLayout;
import protoj.util.ArgRunnable;
import protoj.util.AssembleTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceArchive {
    private final ArchiveFeature parent;
    private TreeMap<String, ArchiveEntry<SourceArchive>> entries;
    private AssembleTask currentAssembleTask;
    private ArchiveEntry<SourceArchive> currentEntry;

    public SourceArchive(ArchiveFeature parent) {
        try {
            this.entries = new TreeMap();
            this.parent = parent;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void addEntry(String name, String manifest, String includes, String excludes) {
        try {
            String fileName = String.format("%s-%s.jar", name, this.parent.getLayout().getSourcePostfix());
            ArchiveEntry entry = new ArchiveEntry(name, this.parent, fileName, manifest, includes, excludes);
            this.entries.put(name, entry);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initConfig(String name, ArgRunnable<SourceArchive> config) {
        try {
            this.getEntry(name).initConfig(config);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initIncludeArchives(String name, String ... archives) {
        try {
            this.getEntry(name).initMergeArchives(archives);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initExcludeArchives(String name, String ... archives) {
        try {
            final List<String> list = Arrays.asList(archives);
            FilenameFilter filter = new FilenameFilter(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                public boolean accept(File dir, String name) {
                    try {
                        return !list.contains(name) && SourceArchive.access$0(SourceArchive.this).isClassesJar(name);
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            };
            this.getEntry(name).initMergeArchives(filter);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createArchives() {
        try {
            Set<String> keys = this.entries.keySet();
            for (String key : keys) {
                this.createArchive(key);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createArchive(String name) {
        try {
            ProjectLayout layout = this.parent.getProject().getLayout();
            this.currentAssembleTask = this.entries.get(name).createAssembleTask(layout.getJavaDir());
            ArgRunnable<SourceArchive> config = this.entries.get(name).getConfig();
            if (config != null) {
                config.run(this);
            }
            this.currentAssembleTask.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void visit(ArgRunnable<ArchiveEntry<SourceArchive>> visitor) {
        try {
            Collection<ArchiveEntry<SourceArchive>> values = this.entries.values();
            for (ArchiveEntry<SourceArchive> entry : values) {
                visitor.run(entry);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArchiveEntry<SourceArchive> getEntry(String name) {
        try {
            return this.entries.get(name);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public AssembleTask getCurrentAssembleTask() {
        try {
            return this.currentAssembleTask;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArchiveEntry<SourceArchive> getCurrentEntry() {
        try {
            return this.currentEntry;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ ArchiveFeature access$0(SourceArchive arg0) {
        try {
            return arg0.parent;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

