/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import org.apache.log4j.Logger;
import org.aspectj.lang.SoftException;
import protoj.lang.ArchiveFeature;
import protoj.lang.CommandStore;
import protoj.lang.CompileFeature;
import protoj.lang.DependencyStore;
import protoj.lang.DirconfFeature;
import protoj.lang.DispatchFeature;
import protoj.lang.InfoFeature;
import protoj.lang.InstructionChain;
import protoj.lang.JunitFeature;
import protoj.lang.ProjectLayout;
import protoj.lang.PropertyStore;
import protoj.lang.ProtoLogger;
import protoj.lang.PublishFeature;
import protoj.lang.ResourceFeature;
import protoj.lang.RetrieveFeature;
import protoj.lang.ScpFeature;
import protoj.lang.ScpconfFeature;
import protoj.lang.ScriptSession;
import protoj.lang.StandardProperties;
import protoj.lang.UploadGoogleCodeFeature;
import protoj.lang.VerifyTarFeature;
import protoj.lang.command.StandardCommands;
import protoj.lang.internal.UserOverride;

public final class StandardProject {
    private PropertyStore propertyStore;
    private DependencyStore dependencyStore;
    private StandardProperties properties;
    private CommandStore commandStore;
    private StandardCommands commands;
    private ProjectLayout layout;
    private ProtoLogger protoLogger;
    private InstructionChain instructionChain;
    private RetrieveFeature retrieveFeature;
    private DispatchFeature dispatchFeature;
    private CompileFeature compileFeature;
    private ResourceFeature resourceFeature;
    private InfoFeature infoFeature;
    private PublishFeature publishFeature;
    private JunitFeature junitFeature;
    private ArchiveFeature archiveFeature;
    private UploadGoogleCodeFeature uploadGoogleCodeFeature;
    private ScpFeature scpFeature;
    private DirconfFeature dirconfFeature;
    private VerifyTarFeature verifyTarFeature;
    private ScpconfFeature scpconfFeature;

    public StandardProject(String[] args, String versionInfo) {
        this(new InstructionChain(args), versionInfo);
        try {
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$3$638cda81(this);
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$7$638cda81(this);
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$8$638cda81(this);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject(File rootDir, String scriptName, String versionInfo) {
        this(new InstructionChain(rootDir, scriptName), versionInfo);
        try {
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$3$638cda81(this);
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$7$638cda81(this);
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$8$638cda81(this);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject(String versionInfo) {
        this(new File(System.getProperty("protoj.rootDir")), System.getProperty("protoj.scriptName"), versionInfo);
        try {
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$3$638cda81(this);
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$7$638cda81(this);
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$8$638cda81(this);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private StandardProject(InstructionChain instructionChain, String versionInfo) {
        try {
            this.instructionChain = instructionChain;
            this.layout = new ProjectLayout(instructionChain.getRootDir(), instructionChain.getScriptName());
            this.protoLogger = new ProtoLogger(this);
            this.commandStore = new CommandStore(this);
            this.propertyStore = new PropertyStore(this);
            this.dependencyStore = new DependencyStore(this);
            this.properties = new StandardProperties(this);
            this.dispatchFeature = new DispatchFeature(this);
            this.resourceFeature = new ResourceFeature(this);
            this.compileFeature = new CompileFeature(this);
            this.retrieveFeature = new RetrieveFeature(this);
            this.infoFeature = new InfoFeature(this, versionInfo);
            this.verifyTarFeature = new VerifyTarFeature(this);
            this.archiveFeature = new ArchiveFeature(this);
            this.commands = new StandardCommands(this);
            this.scpFeature = new ScpFeature(this);
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$3$638cda81(this);
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$7$638cda81(this);
            UserOverride.aspectOf().ajc$afterReturning$protoj_lang_internal_UserOverride$8$638cda81(this);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initPublish(String url) {
        try {
            this.publishFeature = new PublishFeature(this, url);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initJunit(String memory) {
        try {
            this.junitFeature = new JunitFeature(this, memory);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initDirConfig() {
        try {
            this.dirconfFeature = new DirconfFeature(this);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initDirConfig(File home) {
        try {
            this.dirconfFeature = new DirconfFeature(this, home);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initScpConfig(String parentUrl) {
        try {
            this.scpconfFeature = new ScpconfFeature(this, parentUrl);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initUploadGoogleCode(String googleProjectName) {
        try {
            this.uploadGoogleCodeFeature = new UploadGoogleCodeFeature(this, googleProjectName);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ScriptSession createScriptSession() {
        try {
            return new ScriptSession(this.getLayout().getShellScript());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ResourceFeature getResourceFeature() {
        try {
            return this.resourceFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DispatchFeature getDispatchFeature() {
        try {
            return this.dispatchFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public CompileFeature getCompileFeature() {
        try {
            return this.compileFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public RetrieveFeature getRetrieveFeature() {
        try {
            return this.retrieveFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public JunitFeature getJunitFeature() {
        try {
            return this.junitFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArchiveFeature getArchiveFeature() {
        try {
            return this.archiveFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public VerifyTarFeature getVerifyTarFeature() {
        try {
            return this.verifyTarFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public UploadGoogleCodeFeature getUploadGoogleCodeFeature() {
        try {
            return this.uploadGoogleCodeFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ScpFeature getScpFeature() {
        try {
            return this.scpFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DirconfFeature getDirconfFeature() {
        try {
            return this.dirconfFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ScpconfFeature getScpconfFeature() {
        try {
            return this.scpconfFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public InfoFeature getInfoFeature() {
        try {
            return this.infoFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PublishFeature getPublishFeature() {
        try {
            return this.publishFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public InstructionChain getInstructionChain() {
        try {
            return this.instructionChain;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public CommandStore getCommandStore() {
        try {
            return this.commandStore;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardCommands getCommands() {
        try {
            return this.commands;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyStore getDependencyStore() {
        try {
            return this.dependencyStore;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyStore getPropertyStore() {
        try {
            return this.propertyStore;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProperties getProperties() {
        try {
            return this.properties;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ProtoLogger getProtoLogger() {
        try {
            return this.protoLogger;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Logger getLogger() {
        try {
            return this.protoLogger.getProtoLogger();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ProjectLayout getLayout() {
        try {
            return this.layout;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isJdk6() {
        try {
            String version = System.getProperty("java.specification.version");
            return version.contains("6");
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getProtojVersion() {
        try {
            return "1.9.2";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

