/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import org.aspectj.lang.SoftException;
import protoj.lang.PropertyInfo;
import protoj.lang.StandardProject;

public final class StandardProperties {
    private PropertyInfo level;
    private PropertyInfo quiet;
    private PropertyInfo junitMemory;
    private PropertyInfo junitDebug;
    private PropertyInfo junitDebugSuspend;
    private PropertyInfo junitDebugPort;
    private PropertyInfo mainMemory;
    private PropertyInfo mainDebug;
    private PropertyInfo mainDebugSuspend;
    private PropertyInfo mainDebugPort;
    private PropertyInfo gcskip;
    private PropertyInfo scpskip;
    private PropertyInfo statusWindow;
    private PropertyInfo compileSource;
    private PropertyInfo compileTarget;
    private PropertyInfo compileBootclasspath;
    private PropertyInfo compileExtdirs;
    private PropertyInfo compileMemory;
    private PropertyInfo profileHome;
    private PropertyInfo profileUrl;
    private final StandardProject parent;

    public StandardProperties(StandardProject parent) {
        try {
            this.parent = parent;
            this.level = parent.getPropertyStore().addInfo("protoj.level", "INFO", "INFO", "use this to configure application logging by setting to one of the log4j logging level constants");
            this.junitMemory = parent.getPropertyStore().addInfo("protoj.junit.memory", "", "", "Specify the amount of memory for the junit vm, eg \"4m\"");
            this.junitDebug = parent.getPropertyStore().addInfo("protoj.junit.debug", Boolean.FALSE.toString(), Boolean.TRUE.toString(), "Set to true in order to debug the junit vm");
            this.junitDebugSuspend = parent.getPropertyStore().addInfo("protoj.junit.debug.suspend", Boolean.FALSE.toString(), Boolean.TRUE.toString(), "Set to true to suspend the junit vm whilst waiting for a debugger connection");
            this.junitDebugPort = parent.getPropertyStore().addInfo("protoj.junit.debug.port", "11111", "11111", "set to a valid port number to be used when debugging the junit vm");
            this.mainMemory = parent.getPropertyStore().addInfo("protoj.main.memory", "", "", "Specify the amount of memory for the main vm, eg \"4m\"");
            this.mainDebug = parent.getPropertyStore().addInfo("protoj.main.debug", Boolean.FALSE.toString(), Boolean.TRUE.toString(), "Set to true in order to debug the main vm");
            this.mainDebugSuspend = parent.getPropertyStore().addInfo("protoj.main.debug.suspend", Boolean.FALSE.toString(), Boolean.TRUE.toString(), "Set to true to suspend the main vm whilst waiting for a debugger connection");
            this.mainDebugPort = parent.getPropertyStore().addInfo("protoj.main.debug.port", "11111", "11111", "set to a valid port number to be used when debugging the main vm");
            this.quiet = parent.getPropertyStore().addInfo("protoj.quiet", Boolean.FALSE.toString(), Boolean.TRUE.toString(), "set to true to stop most output to the console");
            this.gcskip = parent.getPropertyStore().addInfo("protoj.gcskip", "true", "true", this.getGcskipDescription());
            this.scpskip = parent.getPropertyStore().addInfo("protoj.scpskip", "true", "true", this.getScpskipDescription());
            this.statusWindow = parent.getPropertyStore().addInfo("protoj.statusWindow", "false", "true", this.getStatusWindowDescription());
            this.compileSource = parent.getPropertyStore().addInfo("protoj.compile.source", "the compiler source option, does not default to any value");
            this.compileTarget = parent.getPropertyStore().addInfo("protoj.compile.target", "the compiler target option, does not default to any value");
            this.compileBootclasspath = parent.getPropertyStore().addInfo("protoj.compile.bootclasspath", "the compiler bootclasspath option, does not default to any value");
            this.compileExtdirs = parent.getPropertyStore().addInfo("protoj.compile.extdirs", "the compiler extdirs option, does not default to any value");
            this.compileMemory = parent.getPropertyStore().addInfo("protoj.compile.memory", "the compiler maximum memory option, does not default to any value");
            this.profileHome = parent.getPropertyStore().addInfo("protoj.profile.home", "the directory that contains the profiles available for configuration");
            this.profileUrl = parent.getPropertyStore().addInfo("protoj.profile.url", "the remote url that contains the profiles available for configuration");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject getParent() {
        try {
            return this.parent;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private String getStatusWindowDescription() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("Specify whether or not a window gets displayed indicating project");
            builder.append("\nsuccess (green) or failure (red). The application does not terminate");
            builder.append("\nunless the window is closed.");
            builder.append("\nThe two possible values are:");
            builder.append("\n\n   1. true: the windows gets diplayed, provided there is a gui system available.");
            builder.append("\n\n   2. false: no window gets displayed at all.");
            return builder.toString();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private String getScpskipDescription() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("Specify whether or not the project tar file gets remotely copied during scp.");
            builder.append("\nThe two possible values are:");
            builder.append("\n\n   1. true: the tar file doesn't get copied and an informative message is logged.");
            builder.append("\n\n   2. false: the tar file gets copied normally.");
            return builder.toString();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private String getGcskipDescription() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("Specify whether or not the project tar file gets uploaded to google code.");
            builder.append("\nThe two possible values are:");
            builder.append("\n\n   1. true: the tar file doesn't get posted and an informative message is logged.");
            builder.append("\n\n   2. false: the tar file gets posted normally.");
            return builder.toString();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getLevel() {
        try {
            return this.level;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getMainMemory() {
        try {
            return this.mainMemory;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getCommandMemory(String name) {
        try {
            String key = "protoj.memory." + name;
            return this.parent.getPropertyStore().getLazyInfo(key, "Specify the amount of memory for the command vm, eg \"4m\"", "", "");
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getCommandDebug(String name) {
        try {
            String key = "protoj.debug." + name;
            StringBuilder builder = new StringBuilder();
            builder.append("Set to true in order to debug a vm for the specified command vm");
            builder.append("\nFor example -D" + key);
            return this.parent.getPropertyStore().getLazyInfo(key, builder.toString(), Boolean.FALSE.toString(), Boolean.TRUE.toString());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getCommandDebugSuspend(String name) {
        try {
            String key = "protoj.debug.suspend." + name;
            StringBuilder builder = new StringBuilder();
            builder.append("Set to true in order to suspend a vm when starting a debug session for");
            builder.append(" the specified command. \nFor example -D" + key);
            return this.parent.getPropertyStore().getLazyInfo(key, builder.toString(), Boolean.FALSE.toString(), Boolean.TRUE.toString());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getCommandDebugPort(String name) {
        try {
            String key = "protoj.debug.port." + name;
            StringBuilder builder = new StringBuilder();
            builder.append("Set to the port number to use when starting a debug session for");
            builder.append(" the specified command. \nFor example -D" + key + "=11111");
            return this.parent.getPropertyStore().getLazyInfo(key, builder.toString(), "11111", "11111");
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getQuiet() {
        try {
            return this.quiet;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getJunitMemory() {
        try {
            return this.junitMemory;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getJunitDebug() {
        try {
            return this.junitDebug;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getJunitDebugSuspend() {
        try {
            return this.junitDebugSuspend;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getJunitDebugPort() {
        try {
            return this.junitDebugPort;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getMainDebugProperty() {
        try {
            return this.mainDebug;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getMainDebugSuspend() {
        try {
            return this.mainDebugSuspend;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getMainDebugPort() {
        try {
            return this.mainDebugPort;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getGcskip() {
        try {
            return this.gcskip;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getScpskip() {
        try {
            return this.scpskip;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getStatusWindow() {
        try {
            return this.statusWindow;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getCompileSource() {
        try {
            return this.compileSource;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getCompileTarget() {
        try {
            return this.compileTarget;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getCompileBootclasspath() {
        try {
            return this.compileBootclasspath;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getCompileExtdirs() {
        try {
            return this.compileExtdirs;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getCompileMemory() {
        try {
            return this.compileMemory;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getProfileHome() {
        try {
            return this.profileHome;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public PropertyInfo getProfileUrl() {
        try {
            return this.profileUrl;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

