/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang;

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.GUnzip;
import org.apache.tools.ant.taskdefs.Untar;
import org.aspectj.lang.SoftException;
import protoj.lang.ProjectArchive;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.StandardProject;
import protoj.lang.internal.InformationException;
import protoj.util.AntTarget;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

public final class VerifyTarFeature {
    private StandardProject project;

    public VerifyTarFeature(StandardProject project) {
        try {
            this.project = project;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void verifyTar() {
        try {
            this.extractTarFiles();
            this.applyRwx();
            this.executeSession();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void extractTarFiles() {
        try {
            String compressedPath = this.project.getArchiveFeature().getProjectArchive().getArchivePath();
            boolean exists = new File(compressedPath).exists();
            if (!exists) {
                throw new InformationException("unable to find tar file for tar verification at " + compressedPath);
            }
            ProjectArchive tarFeature = this.project.getArchiveFeature().getProjectArchive();
            File compressedFile = new File(tarFeature.getArchivePath());
            AntTarget target = new AntTarget("extract-tar-files");
            target.initLogging(2);
            GUnzip gunzip = new GUnzip();
            gunzip.setTaskName("gunzip");
            target.addTask((Task)gunzip);
            gunzip.setSrc(compressedFile);
            Untar untar = new Untar();
            untar.setTaskName("untar");
            target.addTask((Task)untar);
            File uncompressedFile = new File(tarFeature.getUncompressedPath());
            untar.setSrc(uncompressedFile);
            untar.setDest(this.getExtractedProject().getLayout().getRootDir().getParentFile());
            target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void applyRwx() {
        try {
            AntTarget target = new AntTarget("extract-tar-files");
            target.initLogging(2);
            Chmod chmod = new Chmod();
            chmod.setTaskName("rwx");
            target.addTask((Task)chmod);
            chmod.setDir(this.getExtractedProject().getLayout().getRootDir());
            chmod.setIncludes("**/*");
            chmod.setPerm("777");
            target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void executeSession() {
        try {
            StandardProject extractedProject = this.getExtractedProject();
            File srcDir = extractedProject.getLayout().getSrcDir();
            if (!srcDir.exists()) {
                throw new RuntimeException("unable to find src directory for the compilation part of tar verification at" + srcDir.getAbsolutePath());
            }
            ScriptSession session = extractedProject.createScriptSession();
            ThrowingListener listener = new ThrowingListener(extractedProject);
            session.addCommand("compile", listener, null);
            session.addCommand("test", listener, null);
            session.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject getExtractedProject() {
        try {
            ProjectLayout thisLayout = this.project.getLayout();
            File verifyTarDir = new File(thisLayout.getTargetDir(), "verify-tar");
            String prefix = this.project.getArchiveFeature().getProjectArchive().getPrefix();
            File rootDir = new File(verifyTarDir, prefix);
            String scriptName = thisLayout.getScriptName();
            StandardProject project = new StandardProject(rootDir, scriptName, null);
            return project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ThrowingListener
    implements ArgRunnable<ScriptSession> {
        private final StandardProject project;

        private ThrowingListener(StandardProject project) {
            try {
                this.project = project;
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        @Override
        public void run(ScriptSession session) {
            try {
                CommandTask exec = session.getCurrentExec();
                System.out.println(exec.getStdout());
                if (!exec.isSuccess()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Extracted project failed tar verification.");
                    builder.append("\nReturn code: ");
                    builder.append(exec.getResult());
                    builder.append("\nScript: ");
                    File script = this.project.getLayout().getShellScript();
                    builder.append(script.getAbsolutePath());
                    builder.append("\nCommand: ");
                    builder.append(session.getCurrentCommand());
                    builder.append("\nstdout:\n");
                    builder.append(exec.getStderr());
                    throw new RuntimeException(builder.toString());
                }
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

