/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.command;

import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.aspectj.lang.SoftException;
import protoj.lang.Command;
import protoj.lang.CommandStore;
import protoj.lang.StandardProject;

public final class CompileCommand {
    private Command delegate;
    private final StandardProject parent;
    private OptionSpec<String> includesOption;
    private OptionSpec<String> excludesOption;

    public CompileCommand(StandardProject parent) {
        try {
            this.parent = parent;
            CommandStore store = parent.getCommandStore();
            this.delegate = store.addCommand("compile", "16m", new Body());
            this.delegate.initHelpResource("/protoj-common/language/english/compile.txt");
            this.delegate.initBootstrapCurrentVm();
            this.delegate.initAliases("build");
            this.includesOption = this.delegate.getParser().accepts(this.getIncludesOption()).withRequiredArg();
            this.excludesOption = this.delegate.getParser().accepts(this.getExcludesOption()).withRequiredArg();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getExcludesOption() {
        try {
            return "excludes";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getIncludesOption() {
        try {
            return "includes";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Command getDelegate() {
        try {
            return this.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ Command access$0(CompileCommand arg0) {
        try {
            return arg0.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$1(CompileCommand arg0) {
        try {
            return arg0.includesOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$2(CompileCommand arg0) {
        try {
            return arg0.excludesOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$3(CompileCommand arg0) {
        try {
            return arg0.parent;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private final class Body
    implements Runnable {
        private Body() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void run() {
            try {
                OptionSet options = CompileCommand.access$0(CompileCommand.this).getOptions();
                String includes = (String)options.valueOf(CompileCommand.access$1(CompileCommand.this));
                if (includes == null) {
                    includes = "*";
                }
                String excludes = (String)options.valueOf(CompileCommand.access$2(CompileCommand.this));
                CompileCommand.access$3(CompileCommand.this).getCompileFeature().compile(includes, excludes);
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

