/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.command;

import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.aspectj.lang.SoftException;
import protoj.lang.Command;
import protoj.lang.CommandStore;
import protoj.lang.DirconfFeature;
import protoj.lang.StandardProject;

public final class DirconfCommand {
    private Command delegate;
    private OptionSpec<?> interpolateOption;
    private OptionSpec<?> cleanOption;
    private final StandardProject project;
    private OptionSpec<String> nameOption;

    public DirconfCommand(StandardProject project) {
        try {
            this.project = project;
            CommandStore store = project.getCommandStore();
            this.delegate = store.addCommand("dirconf", "32m", new Body());
            this.delegate.initHelpResource("/protoj-common/language/english/dirconf.txt");
            this.delegate.initBootstrapCurrentVm();
            this.interpolateOption = this.delegate.getParser().accepts(this.getInterpolateOption());
            this.cleanOption = this.delegate.getParser().accepts(this.getCleanOption());
            this.nameOption = this.delegate.getParser().accepts(this.getNameOption()).withRequiredArg();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getCleanOption() {
        try {
            return "clean";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getNameOption() {
        try {
            return "name";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getInterpolateOption() {
        try {
            return "interpolate";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Command getDelegate() {
        try {
            return this.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$0(DirconfCommand arg0) {
        try {
            return arg0.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$1(DirconfCommand arg0) {
        try {
            return arg0.nameOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ Command access$2(DirconfCommand arg0) {
        try {
            return arg0.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$3(DirconfCommand arg0) {
        try {
            return arg0.interpolateOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$4(DirconfCommand arg0) {
        try {
            return arg0.cleanOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public final class Body
    implements Runnable {
        public Body() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void run() {
            try {
                OptionSet options = DirconfCommand.this.getDelegate().getOptions();
                DirconfFeature feature = DirconfCommand.access$0(DirconfCommand.this).getDirconfFeature();
                if (!options.has(DirconfCommand.access$1(DirconfCommand.this))) {
                    String hint = "the name option is mandatory";
                    DirconfCommand.access$2(DirconfCommand.this).throwBadOptionsException(hint);
                }
                String name = (String)options.valueOf(DirconfCommand.access$1(DirconfCommand.this));
                boolean interpolate = options.has(DirconfCommand.access$3(DirconfCommand.this));
                if (options.has(DirconfCommand.access$4(DirconfCommand.this))) {
                    feature.clean(name);
                } else {
                    feature.configure(name, interpolate);
                }
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

