/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.command;

import java.util.List;
import joptsimple.OptionSet;
import org.aspectj.lang.SoftException;
import protoj.lang.Command;
import protoj.lang.CommandStore;
import protoj.lang.PropertyInfo;
import protoj.lang.StandardProject;

public final class HelpCommand {
    private Command delegate;
    private final StandardProject project;

    public HelpCommand(StandardProject project) {
        try {
            this.project = project;
            CommandStore store = project.getCommandStore();
            this.delegate = store.addCommand("help", "16m", new Body());
            this.delegate.initHelpResource("/protoj-common/language/english/help.txt");
            this.delegate.initAliases("-help", "--help", "h", "-h", "--h", "?");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Command getDelegate() {
        try {
            return this.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ Command access$0(HelpCommand arg0) {
        try {
            return arg0.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$1(HelpCommand arg0) {
        try {
            return arg0.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private final class Body
    implements Runnable {
        private Body() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void run() {
            try {
                OptionSet options = HelpCommand.access$0(HelpCommand.this).getOptions();
                List args = options.nonOptionArguments();
                String name = args.size() > 0 ? (String)args.get(0) : null;
                Command command = HelpCommand.access$1(HelpCommand.this).getCommandStore().getCommand(name);
                PropertyInfo property = HelpCommand.access$1(HelpCommand.this).getPropertyStore().getInfo(name);
                if (command != null) {
                    HelpCommand.access$1(HelpCommand.this).getInfoFeature().reportCommandHelp(command);
                } else if (property != null) {
                    HelpCommand.access$1(HelpCommand.this).getInfoFeature().reportPropertyHelp(property);
                } else {
                    HelpCommand.access$1(HelpCommand.this).getInfoFeature().reportProjectHelp();
                }
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

